# jedit_ui.tcl - user interface for jedit
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

j:ldb:set_defaults {
  {{No file} {No file}}
  {{(No file yet)} {(No file yet)}}
  {{(unspecified)} {(unspecified)}}
}

######################################################################
# create main window
######################################################################

proc jedit:mkwindow { window } {
  j:debug
  global argv0 MODE
  
  set prefix [jedit:top_to_prefix $window]
  
  set menu $prefix.menu
  set main $prefix.main
  
  frame $menu -borderwidth 2 -relief raised
  pack $menu -fill x
  
# jedit:mkmenus ...		;# done by jedit:apply_mode
# jedit:mkbuttons ...		;# done by jedit:apply_mode
  jedit:mkmain $main
  pack $main -expand yes -fill both
  
  if {[winfo class $window] == "Toplevel"} {
    wm title $window [j:ldb {No file}]
    wm iconname $window [j:ldb {No file}]
  }
}

######################################################################
# create text window with scrollbar
######################################################################

proc jedit:mkmain { w } {
  j:debug
  global J_PREFS
  if {[lsearch [array names J_PREFS] {scrollbarside}] == -1} {
    set J_PREFS(scrollbarside) right ;# make sure it's defined
  }
  
  frame $w
  
  frame $w.status
  label $w.status.name -relief flat -text [j:ldb {(No file yet)}]
  label $w.status.mode -relief flat -text [j:ldb {(unspecified)}]
  #
  # text widget is configured near end, after user's config file is read
  #
  text $w.t -yscroll "$w.s set" -setgrid true
  
  scrollbar $w.s -command "$w.t yview"
  
  pack $w.status.name -in $w.status -side left -fill x
  pack $w.status.mode -in $w.status -side right -fill x
  pack $w.status -in $w -side top -fill x
  pack $w.s -in $w -side $J_PREFS(scrollbarside) -fill y
  pack $w.t -in $w -side $J_PREFS(scrollbarside) -expand yes -fill both
  
  focus $w.t
  catch {focus default $w.t}		;# caught for Tk 4.0
  tk_bindForTraversal $w.t
  
  return $w
}

######################################################################
# create button bar
######################################################################

proc jedit:mkbuttonbar { w t } {
  global JEDIT_MODEPREFS
  
  j:debug
  if [winfo exists $w] {
    destroy $w
  }
  
  frame $w
  
  set mode [jedit:get_mode $t]
  
  if {"x[info procs mode:${mode}:mkbuttons]" != "x"} {
    mode:${mode}:mkbuttons $w.b $t
  } else {
    j:command:buttonbar $w.b $t $JEDIT_MODEPREFS($mode,buttons)
  }
  pack $w.b [j:rule $w] -in $w -side top -fill x
  return $w
}

######################################################################
# set the label at the top of the window to current mode and filename
######################################################################

proc jedit:set_label { window {title USE_FILENAME} } {
  j:debug
  jedit:set_filename_label $window $title
  jedit:set_mode_label $window [jedit:get_mode $window]
}

######################################################################
# set the label at the top of the window to current filename
######################################################################

proc jedit:set_filename_label { window {title USE_FILENAME} } {
  set file_label [jedit:top_to_prefix $window].main.status.name
  
  set filename [jedit:get_filename $window]
  if {"x$filename" == "x"} {
    set filename [j:ldb {No file}]
  }
  
  if {$title == "USE_FILENAME"} then {set title [file tail $filename]}
  if {$title == "FULL_FILENAME"} then {set title $filename}
  
  if [winfo exists $file_label] {
    $file_label configure -text $title
  }
  
  if {[winfo class $window] == "Toplevel"} {
    wm title $window $title
    wm iconname $window $title
  }
}

######################################################################
# set the label at the top of the window to current mode
######################################################################

proc jedit:set_mode_label { window {mode USE_MODE} } {
  if {$mode == "USE_MODE"} then {set mode [jedit:get_mode $window]}
  
  set mode_label [jedit:top_to_prefix $window].main.status.mode
  if [winfo exists $mode_label] {
    $mode_label configure -text [jedit:get_mode $window]
  }
}

######################################################################
# position insert comfortably
######################################################################

proc jedit:yview_insert {t} {
  set sb [jedit:text_to_scrollbar $t]
  set insertline [lindex [split [$t index insert] .] 0]
  $t yview -pickplace {insert -5 lines}
  set lastline [lindex [$sb get] 3]		;# last visible line in $t
  if {$lastline >= $insertline} {
    $t yview -pickplace insert
  }
}


######################################################################
# set text for current preferences
######################################################################

proc jedit:configure_text { t } {
  global JEDIT_MODEPREFS JEDIT_PREFS
  
  set mode [jedit:get_mode $t]
  
  catch {$t configure \
    -background $JEDIT_PREFS(textbg) \
    -foreground $JEDIT_PREFS(textfg) \
    -insertbackground $JEDIT_PREFS(textfg) \
    -selectbackground $JEDIT_PREFS(textsb) \
    -selectforeground $JEDIT_PREFS(textsf) \
    -selectborderwidth $JEDIT_PREFS(textsbw) \
    -borderwidth $JEDIT_PREFS(textbw) \
    -insertwidth $JEDIT_PREFS(textiw) \
    -width $JEDIT_MODEPREFS($mode,textwidth) \
    -height $JEDIT_MODEPREFS($mode,textheight) \
    -wrap $JEDIT_MODEPREFS($mode,textwrap)
  }
  j:configure_font $t $JEDIT_MODEPREFS($mode,textfont) ;# knows about `default'
  # for rich-text:
  j:tag:configure_fonts $t
}

######################################################################
# various widget-name-guessing procedures
######################################################################

# .jedit1.main.t -> .jedit1

proc jedit:text_to_top { t } {
  return [winfo parent [winfo parent $t]]
}

# .jedit1.main.t -> .jedit1.main.s

proc jedit:text_to_scrollbar { t } {
  return "[winfo parent $t].s"
}

# .jedit1.menu -> .jedit1

proc jedit:menubar_to_top { mb } {
  return [winfo parent $mb]
}

# .jedit -> .jedit, but "." -> ""

proc jedit:top_to_prefix { top } {
  if {[string compare "." $top] == 0} {
    return ""
  } else {
    return $top
  }
}

# .jedit -> .jedit.main.t, but . -> .main.t

proc jedit:top_to_text { top } {
  if {[string compare "." $top] == 0} {
    set prefix ""
  } else {
    set prefix $top
  }
  return ${prefix}.main.t
}

# .jedit -> .jedit.buttons, but . -> .buttons

proc jedit:top_to_buttonbar { top } {
  if {[string compare "." $top] == 0} {
    set prefix ""
  } else {
    set prefix $top
  }
  return ${prefix}.buttons
}

# .jedit -> .jedit.menu, but . -> .menu

proc jedit:top_to_menubar { top } {
  if {[string compare "." $top] == 0} {
    set prefix ""
  } else {
    set prefix $top
  }
  return ${prefix}.menu
}






