# jconfirm.tcl - (optional) confirmation panel
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
j:default J_PREFS(autoposition) 0
j:default J_PREFS(confirm) 1
#
######################################################################


######################################################################
# j:confirm ?options? - Cancel/OK dialogue box
# options include
#   -title (default "Confirm")
#   -text (default "Are you sure?")
#   -priority (default 0)
#   -yesbutton (default "OK")
#   -nobutton (default "Cancel")
# returns true (1) on OK; false (0) on Cancel
# if (priority == 0 && $J_PREFS(confirm) == 0), the dialogue box is
#   not displayed; it always returns 1
######################################################################

proc j:confirm { args } {
  j:parse_args {
    {title Confirm}
    {priority 0}
    {text "Are you sure?"}
    {yesbutton OK}
    {nobutton Cancel}
  }
  
  set title [uplevel 1 [list j:ldb $title]]
  set text [uplevel 1 [list j:ldb $text]]
  set yesbutton [uplevel 1 [list j:ldb $yesbutton]]
  set nobutton [uplevel 1 [list j:ldb $nobutton]]
  
  global confirm_result
  global J_PREFS			;# for J_PREFS(confirm)

  if { (! $J_PREFS(confirm)) && (! $priority) } {
    return 1
  }
  
  set old_focus [focus]			;# so we can restore original focus

  toplevel .confirm
  wm title .confirm $title
  
  message .confirm.msg -width 300 -anchor w -text $text
  j:buttonbar .confirm.b -default ok -buttons [format {
    {ok {%s} {set confirm_result 1; destroy .confirm}}
    {cancel {%s} {set confirm_result 0; destroy .confirm}}
  } $yesbutton $nobutton]
  
  pack .confirm.msg -side top -fill both -expand yes -padx 10 -pady 10
  pack [j:rule .confirm -width 200] -side top -fill x
  pack .confirm.b -side bottom -fill x
  
  j:dialogue .confirm		;# position in centre of screen

  focus .confirm
  j:default_button .confirm.b.ok .confirm
  j:cancel_button .confirm.b.cancel .confirm
  update
  grab .confirm
  tkwait window .confirm
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
  return $confirm_result
}






