' $Id: textundo.n,v 1.1 1995/06/12 09:03:35 jfontain Exp $
.TH textundo tk
.BS
.SH NAME
textundo \- undo utility for Text widget
.SH SYNOPSIS
\fBnew textUndoer \fItextWidget ?depth?\fR
.in
\fBdelete textUndoer \fIid\fR
.SH DESCRIPTION
.PP
A \fBtextUndoer\fR object is used to allow undoing on an existing Tk text widget. By default, any number of insertions or deletions can be undone. Optionally, this number can have a limit, the oldest changes then being discarded when the \fBtextUndoer\fR object buffer fills up.
.PP
It is usually not necessary to delete the \fBtextUndoer\fR object, for it is automatically deleted when its companion Text widget is destroyed.
.PP
When the \fBtextUndoer\fR object is deleted, the original Text widget bindings are restored.
.SH CREATION PARAMETERS
.PP
Besides the \fItextWidget\fR argument, the constructor takes one optional argument: the \fIdepth\fR or maximum number of changes (insertions or deletions) that can de undone.
.SH UNDOING
.PP
Once the \fBtextUndoer\fR object is created, changes to the Text widget contents can be undone by successively hitting \fIControl-U\fR or calling the following member function, as in:
.sp
.RS
.nf
\fBtextUndoer::undo \fI$id\fR
.fi
.RE
.SH RESETTING
.PP
The \fBtextUndoer\fR object undo command buffer can be emptied at any time using:
.sp
.RS
.nf
\fBtextUndoer::reset \fI$id\fR
.fi
.RE
.PP
The recording of the changes to the Text widget then resumes immediately.
.SH LIMITATIONS
.PP
Changes related to tags and embedded windows cannot be undone.
.SH KEYWORDS
.PP
undo, text, new, delete
