.\" Copyright (c) 1993 by Bao Trinh
.TH TKSOL 1 "January 5, 1994"
.SH NAME
tksol \- Tcl/Tk based solitaire card game
.PP

.SH DESCRIPTION
\fITkSol\fP is a version of the card game solitaire written with
the Tcl/Tk language.  It requires Tcl 7.0 or above and Tk 3.3 or 
above.  A color monitor is recommended, although TkSol can be 
played on a monochrome monitor if one is desperate enough.

In this manpage, the two stacks on the topleft of the canvas are
referred to as the \fIDrawLeft\fP and \fIDrawRight\fP stacks,
respectively.  The four stacks on the topright of the canvas are
referred to as \fIEndStk0\fP to \fIEndStk3\fP, from left to right.
The seven stacks on the bottom of the canvas are referred to as
\fIPlayStk0\fP to \fIPlayStk6\fP, from left to right.

.SH COMMAND LINE OPTIONS
TkSol accepts the following command line options, which \fIoverride\fP
those specified in the ~/.tksolrc file (see Customization section):
.TP
-background \fIcolor\fP
This option specifies the canvas background color.
.TP
-bitmap \fIbitmap\fP
This option specifies the bitmap of the \fIfacedown\fP cards.
.TP
-card_dir \fIdirectory\fP
This option specifies the directory where the bitmaps of the
\fIfaceup\fP cards are located.
.TP
-debug
This option is used for debugging only.
.TP
-down_dir \fIdirectory\fP
This option specifies the directory where the bitmaps of the
\fIfacedown\fP cards are located.
.TP
-flip \fInumber\fP
This option specifies the number of cards from the \fIDrawLeft\fP
stack that is flipped over to the \fIDrawRight\fP stack by each 
single click.

.SH BUTTONS
TkSol has several buttons, some of which may not be visible at all 
time, depending on whether the associated functions are enabled at
that particular instance of time or not.
.TP
\fIQuit\fP
Quit the game.
.TP
\fIDeal\fP
Start a new game.  The score is reset to 0.
.TP
\fIUndo\fP
Undo the last move.  TkSol keeps an undo stack containing all the
moves that you make in a game so you can undo all the way to the
start if desire.
.TP
\fIFinish\fP
Autofinish a game, currently enabled only when the flip option is set
to 1.  This button will appear when the last facedown card on the
\fIPlayStk's\fP is flipped up.  Note that there may still be facedown
cards on the \fIDrawLeft\fP stack.

.SH CUSTOMIZATION
In addition to the command line options, TkSol can also be customized
by setting various options in the \fI~/.tksolrc\fP file.  This file
contains one or more lines, each of which is of the following form:

.Ds
    \fIset\fP <option_name> <value>, eg.

    set tksol(canvas.background) ForestGreen
    set tksol(flip) 3
.De

Note that the command line options override the corresponding options
set in the ~/.tksolrc file.

The following options can be set in ~/.tksolrc:
.TP
tksol(\fIdebug\fP)
This option turns on debugging mode.  The default value is \fI0\fP,
which is off.
.TP
tksol(\fIcanvas.background\fP)
This option specifies the background color of the canvas.  The
default color is \fIForestGreen\fP.
.TP
tksol(\fIflip\fP)
This option specifies the number of cards from the \fIDrawLeft\fP
stack that is flipped over to the \fIDrawRight\fP stack by each 
single click.  The maximum value is 8.  The default value is \fI1\fP.
.TP
tksol(\fIbitmap\fP)
This option specifies the bitmap of the \fIfacedown\fP cards.  The
default bitmap is \fIdown\fP.
.TP
tksol(\fIbitmap.card_directory\fP)
This option specifies the directory where the bitmaps for the faceup
cards are stored.  The default directory is \fI@cardbitmaps@\fP.
.TP
tksol(\fIbitmap.down_directory\fP)
This option specifies the directory where the bitmaps for the facedown
cards are stored.  The default directory is \fI@downbitmaps@\fP.
.TP
tksol(\fIbitmap.foreground\fP)
.ns
.TP
tksol(\fIbitmap.background\fP)
These options specify the foreground and background colors of the
bitmap of the \fIfacedown\fP cards.  The default colors are
\fIBlue\fP and \fIWhite\fP, respectively.
.TP
tksol(\fIcard.blackForeground\fP)
.ns
.TP
tksol(\fIcard.blackBackground\fP)
These options specify the foreground and background colors of the
bitmap of the \fIblack\fP suit cards.  The default colors are
\fIBlack\fP and \fIWhite\fP, respectively.
.TP
tksol(\fIcard.redForeground\fP)
.ns
.TP
tksol(\fIcard.redBackground\fP)
This option specifies the foreground and background colors of the
bitmap of the \fIred\fP suit cards.  The default colors are \fIRed\fP
and \fIWhite\fP, respectively.
.TP
tksol(\fIcard.realWidth\fP)
This option specifies the \fIactual\fP width of the bitmap of the
card.  The default width is \fI72\fP pixels.
.TP
tksol(\fIcard.realHeight\fP)
This option specifies the \fIactual\fP height of the bitmap of the
card.  The default actual height is \fI99\fP pixels.
.TP
tksol(\fIcard.width\fP)
This option specifies the \fIpadded\fP width of the bitmap of the
card.  The default padded width is \fI80\fP pixels.
.TP
tksol(\fIcard.height\fP)
This option specifies the \fIpadded\fP height of the bitmap of the
card.  The default height is \fI100\fP pixels.
.TP
tksol(\fIstack.spacing\fP)
This option specifies the spacing between the card stacks.  The
default spacing is \fI10\fP pixels.
.TP
tksol(\fIstack.up_spacing\fP)
This option specifies the vertical spacing between the faceup cards
on a stack.  The default spacing is \fI15\fP pixels.
.TP
tksol(\fIstack.down_spacing\fP)
This option specifies the vertical spacing between the facedown cards
on a stack.  The default spacing is \fI5\fP pixels.
.TP
tksol(\fIstack.side_spacing\fP)
This option specifies the horizontal spacing between the cards on the
\fIDrawRight\fP stack when more than one card is flipped over from the
\fIDrawLeft\fP stack.  The default spacing is \fI15\fP pixels.
.TP
tksol(\fIside_margin\fP)
This option specifies the left and right margins on the canvas.  The
default margin for both left and right is \fI15\fP pixels.
.TP
tksol(\fItop_level\fP)
This option specifies the position of the top edge of the stacks on
the top level, namely the \fIDrawLeft\fP and \fIDrawRight\fP stacks
and the \fIEndStk's\fP.  The default value is \fI15\fP pixels from the
top of the canvas.
.TP
tksol(\fIbottom_level\fP)
This option specifies the position of the top edge of the stacks on
the bottom level, namely the \fIPlayStk's\fP .  The default value is
\fI150\fP pixels from the top of the canvas.
.TP
tksol(\fIbutton.font\fP)
This option specifies the font for the buttons and scorebox.  The
default font is \fI9x15\fP.
.TP
tksol(\fIbutton.foreground\fP)
.ns
.TP
tksol(\fIbutton.background\fP)
These options specify the foreground and background colors of the
buttons when not depressed.  The default colors are \fIWhite\fP and
\fIDeepSkyBlue1\fP, respectively.
.TP
tksol(\fIbutton.activeForeground\fP)
.ns
.TP
tksol(\fIbutton.activeBackground\fP)
These options specify the foreground and background colors of the
buttons when depressed.  The default colors are \fIBlack\fP and
\fIBisque2\fP, respectively.

.SH NOTES
Double clicking on a faceup card will, if possible, move it to the
appropriate \fIEndStk\fP.  It is possible to move cards from the
\fIEndStk's\fP down to the \fIPlayStk's\fP.

The width and height of the canvas can't be set explicitly in this
version.  The canvas width is computed with the following twisted
formula

.ce 1
(7 * card.width) + (2 * side_margin) + (6 * stack.spacing)

while that for the canvas height is

.ce 1
(card.height * 4.5)

Note that the \fItop_level\fP and \fIbottom_level\fP options have to
be set explicitly, ie. they do not depend on other options.  

You can probably specify some X defaults by setting the various X
resources, but I haven't tried doing it that way.

.SH SCORING

The current scoring scheme is \fIincomplete\fP and a little bit
haphazard. The score is reset to 0 after every game.  5 points is
given for every card that is moved from the \fIDrawRight\fP stack down
to the \fIPlayStk's\fP. 10 points is given for every card that is
moved to the \fIEndStk's\fP.  Finally, 1 point is subtracted for each
movement from the \fIEndStk's\fP to the \fIPlayStk's\fP or movement
between the \fIPlayStk's\fP themselves.  Currently, other than the
rules already stated above, no penalty is assessed for undo'ing a
move.

.SH BUGS

TkSol does not currently check for the colormodel.  As a result, on a
monochrome monitor, a button's text will not be visible if the cursor 
is not over the button.  Hopefully, newer versions will come with a
more decent monochrome setup.

.SH AUTHOR
Bao Trinh (bao@cs.umd.edu).

.SH COPYRIGHT
Copyright (c) 1993 by Bao Trinh.

Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.
