#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ut_ro.t,v 1.1.1.1 1995/06/06 14:16:00 andy Exp $
#
# Read file contents that are in tag=value format. 
#

proc ut_ro { PathName DataBufArr {DataList {}} } {

	set in [open $PathName]
	upvar $DataBufArr z 

	if {[llength $DataList] > 0} {
	   foreach DataElem [lrange $DataList 0 end] {
	      set tag [format "%s=*" $DataElem]	
	      #set tags [format "%s=%%s" $DataElem]	
	      seek $in 0 start
	      while {[gets $in ln] >= 0} {
		 #find DataList tag 
		 if {[string match $tag $ln]} {
		    #scan $ln $tags x
		    set x [lindex [split $ln "="] 1]
		    if {![info exists x]} {
		       set "z($DataElem)" {} 
		    } else {
		       set "z($DataElem)" [string trim $x]
		    }
		    break
	         }
	      }
	   }
	} else {
	   while {[gets $in ln] >= 0} {
	      # Ignore anything but tag=value entries.
	      if {![string match *=* $ln]} {
		 continue
	      }
	      set pair [split $ln "="]
	      set tag [lindex $pair 0]
	      set val [lindex $pair 1]
	      set "z($tag)" [string trim $val] 
	   }
	}

	close $in
	return 1
}
