# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: select.t,v 1.2 1995/07/17 01:13:21 andy Exp $
#
# Make a toplevel window that shows the files in a directory and allow user
# to navigate around.
#

proc fileselect { w bx } {

    catch {destroy $w}
    toplevel $w
    wm geometry $w 550x500
    wm minsize $w 100 100

    global curWorkDir
    global curFltr
    set curWorkDir [exec pwd]
    set curFltr {*}
    wm title $w "Directory Browser" 

    ut_mkFrame $w {f {} {}}
    ut_mkFrame $w.f {buttons {-relief flat} {-side bottom -fill x}} 
    ut_mkFrame $w.f {oper {} {-side bottom -fill x}} 
    set cancel_attr [list DISMISS -command "destroy $w"]
    ut_mkButton $w.f.buttons [list b_cancel $cancel_attr {-side top -fill x}]
    ut_mkLabel $w.f.oper {l_dir {"Current Directory:"} {-side left}}
    ut_mkEntry $w.f.oper [list \
	e_dir [list -width 35 -rel [entryRelief]] {-side left} getDirListing]
    ut_mkEntry $w.f.oper [list \
	e_fltr [list -wid 10 -rel [entryRelief]] {-side right} getFilterListing]
    ut_mkLabel $w.f.oper {l_fltr {"Directory Filter:"} {-side right}}
    ut_updateEntry $w.f.oper.e_dir $curWorkDir 
    ut_updateEntry $w.f.oper.e_fltr $curFltr 

    scrollbar $w.f.scr -relief sunken -command "$w.f.bx yview" 
    listbox $w.f.bx -yscroll "$w.f.scr set" -relief sunken -font fixed \
	-selectmode single

    pack $w.f.scr -side right -fill y
    pack $w.f.bx -side left -expand 1 -fill both 

    getDirListing $w.f.oper.e_dir

    bind $w.f.bx <B1-ButtonRelease> "navigate_cb $w $bx"

}

proc getDirListing { e } {
    global curWorkDir
    global curFltr

    set curWorkDir [$e get]
    if {![file isdirectory $curWorkDir]} {
	return
    }

    if {![file readable $curWorkDir]} {
	tk_dialog .err "Ooops!" \
	    "You have no read access to that directory" info 0 OK
	return
    }

    if {[catch {set files [split [exec ls -al $curWorkDir] \n]} res]} {
	tk_dialog .err "Ooops!" "$res" info 0 OK
	[winfo toplevel $e].f.bx select clear 0 end
	return
    }
    [winfo toplevel $e].f.bx delete 0 end
    foreach ln $files {
	regexp {[^ ]+$} $ln filename
	if {[string match $curFltr $filename] || [file isdirectory $filename]} {
	    [winfo toplevel $e].f.bx insert end $ln
	}
    }
}

proc getFilterListing { e } {
    global curWorkDir
    global curFltr

    set curFltr [$e get]
    set files [split [exec ls -al $curWorkDir] \n]
    [winfo toplevel $e].f.bx delete 0 end
    foreach ln $files {
	regexp {[^ ]+$} $ln filename
	if {[string match $curFltr $filename] || [file isdirectory $filename]} {
	    [winfo toplevel $e].f.bx insert end $ln
	}
    }
}

proc navigate_cb { w bx } {

    global curWorkDir

    set idx [$w.f.bx curselection]
    set filename [$w.f.bx get $idx]
    # Extract the filename from the selected item.
    regexp {[^ ]+$} $filename choice
    if {[file isdirectory $curWorkDir/$choice]} {
	switch -exact -- $choice .. {
	    set curWorkDir [file dirname $curWorkDir] 
	} . {
	    $w.f.bx select clear 0 end
	    return
	} default {
	    set curWorkDir $curWorkDir/$choice
	}
	if {[file readable $curWorkDir]} {
	    ut_updateEntry $w.f.oper.e_dir $curWorkDir
	    getDirListing $w.f.oper.e_dir
	} else {
	    tk_dialog .err "Ooops!" \
		"You have no read access to that directory" info 0 OK
	}
    } else {
	fileselect_cb $w $bx
    }
} 

proc fileselect_cb { w bx } {

    global curWorkDir

    set selections [$w.f.bx curselection] 
    foreach idx $selections {
	set filename [$w.f.bx get $idx]
	# Extract the filename from the selected item.
	regexp {[^ ]+$} $filename choice
	# Enter this file in the list to fax
	$bx insert end $curWorkDir/$choice
    }
    $w.f.bx select clear 0 end
}
