.TH ReplayXt 1 "18 April 1994"

.\" program start
.de PS
.nf
.na
.RS 0.5i
..

.\" program end
.de PE
.fi
.ad
.RE 0.5i
..

.\" display start
.de DS
.nf
.na
.RS 0.5i
..

.\" display end
.de DE
.fi
.ad
.RE 0.5i
..

.SH NAME
.B ReplayXt
- a library allowing replays of Xt applications

.SH SYNOPSIS
#include <ReplayXt.h>
.br
RXt_RegisterPlayer(Widget \fItoplevel\fP,
.br
                  char *\fIrules_file\fP,
.br
                  char *\fIdata_file\fP,
.br
                  Boolean \fIverbose\fP)
.br
RXt_RegisterTopWidget(Widget \fIw\fP)
.br
RXt_StartRecorder(XtAppContext \fIapp_context\fP)

.SH Introduction
This is a library of functions built upon  the command language
.I tcl
that allows an Xt application
to become ``replay'' aware. By including the command 
.I RXtRegisterPlayer() 
after creation of the toplevel widget of an application, the application will
read rules and instructions from the two files and execute them.
The files are source files in \fItcl\fP, which has been extended
to have commands that will cause Xt widgets to execute actions, resulting
in an automatic play of the actions. This can be used either for
an automatic demonstration of the application, or for an automated test
process.

Widgets are named in the script files from a root in the widget hierarchy.
The usual root is the ApplicationShell of the application. Other widgets
may be registered as potential root widgets by RXt_RegisterTopWidget.
This \fImust\fP be used to register toplevel shells that are not parented 
from the ApplicationShell, but may be used to abbreviate the naming path
for other widgets.

The rules file is read before execution of the event loop,
and the data file is executed during the event loop.

.I RXt_StartRecorder()
sends to standard output a list of tcl commands suitable for processing
by RXt_RegisterPlayer(). It may be used as the basis of a replay script.
It uses the actual x and y co-ordinates of events, so is not robust
to resizing, etc, of applications. It provides no procedural
abstraction of actions.
It does not capture mouse motion.

.SH Commands

The tcl language has been extended by the following commands:
.RS 5
callActionProc
.I "widget action args...
.br
sleep
.I milliseconds
.br
getValues
.I "widget args...
.br
warpPointer
.I "widget x y
.br
setTopWidget
.I widget-name
.br
isManaged
.I widget-name
.br
isRealized
.I widget-name
.br
isSensitive
.I widget-name
.RE

.SH "Widget names

Widgets are named using the ``.'' and ``*'' notations from Xt for pathnames.
For example, the widget ``btn'' with parent ``rowcol'', which in turn
has parent ``mainwin'' may be known by any  of
.PS
mainwin.rowcol.btn
mainwin*rowcol*btn
*rowcol.btn
mainwin*btn
*btn
.PE
etc.

The root of the naming system is the application name, and this is
not needed in the path. All other widgets are, unless replaced by ``*''
matching. Internally, 
.I XtNameToWidget() 
is used to find widgets (or
gadgets) from their names. It is your responsibility to ensure that
when patterns are used the correct widget is matched.
In particular, if there are two or more widgets with the same name
then the Intrinsics do not specify which of these will be chosen by
.I XtNameToWidget().
 
.SH callActionProc

This command takes a widget (not a gadget), an action and an optional
set of parameters. The action is exactly as documented in the 
reference manual for that widget set. For example, it could be
.I set() 
for the Athena button widget, or
.I Activate() 
for the Motif PushButton widget.

Some actions look at the event that normally triggers an action.
In this system there is no such event, and one is constructed.
It may need to be of a particular type, with certain fields of the 
event set. Note that this is usually not documented for a widget.

To set the type of the event, use the option ``-type \fItype\fP''.
The values of \fItype\fP can be
.RS 5
ButtonPress
.br
ButtonRelease
.br
KeyPress
.br
KeyRelease
.RE

Additional options for ButtonPress and ButtonRelease are
.RS 5
-x \fIx\fP
.br
-y \fIy\fP
.br
-button \fIbutton\fP
.RE
where \fIbutton\fP
is one of Button1, Button2, Button3, Button4 or Button5. The
default value of button is Button1, and of x and y is zero.

Additional options for KeyPress and KeyRelease are
.RS 5
-x \fIx\fP
.br
-y \fIy\fP
.br
-keysym \fIkeysym\fP
.br
-modifiers \fImodifiers\fP
.RE
The keysyms are documented in the Xlib literature. For printable
characters, they are the characters themselves: ``a'', ``A'', ``1'', 
``2'', ``!'', etc. For other characters, names are used, such as
``Return''.

The modifiers are the standard set of Xlib modifiers, ``Control'',
``Shift'', ``Lock'', ``Mod1'' - ``Mod5'' plus additional ones defined
by Xt of ``Meta'', ``Alt'', ``Super'' and ``Hyper''. The argument is
a list of these.

.SH sleep
This command takes one argument, a number of milliseconds to suspend
execution of the replay. This only suspends replay of the data or rules
file, and allows for normal Xt event processing to take place.
This means that the application will still be responsive to expose, 
resize, etc, events while sleeping.


.SH getValues

This command takes a widget (or gadget) as argument, followed by a list of
argument+value pairs, such as ``-width w -height h''.
The argument is the string value of the widget's resource, 
as can be used in resource files.
The value is stored in the
.I tcl 
variable given in that position.

.SH warpPointer

This command takes the name of a widget (or gadget) and the x and y
coordinates to move to within the window of this object. In the case
of a widget, this is the normal window for the widget, but for a gadget
it is the window that the gadget is drawn in. For a widget, the 
coordinates are relative to the boundaries of the widget, but for a
gadget are relative to the boundaries of the window (normally of the
widget containing it).

.SH setTopWidget

In a tcl script, the root of the widget tree used can be changed using
setTopWidget. This takes one parameter which is the name of a widget
which has been registered using RXt_RegisterTopWidget. 
The original ApplicationShell has its name in $argv0.

.SH send

The ``send'' mechanism is a means whereby tcl applications running
under X can send commands from one application to be executed within
another. This is found in Tk applications and in applications compiled
with the
.I tclXtSend 
library. This package includes this library.

Commands may be sent to another application by knowing its name, which
is usually the name as known to X. Then the command is given in another
argument.
.PS
send name command
.PE
For example,
.PS
send xcalc {callActionProc *ti.button24 set()}
.PE

The most likely use of this in this system is for one application to
run two or more other applications in a synchronised manner, which
would be difficult if they ran from independant files.

.SH isManaged, isRealized, isSensitive

These all take one argument which is a widget name, and return the 
value "true" or "false" according to the state of the widget. This
gives information which is not available through getValues.

.SH "Athena example

The example in the xcalc directory is the standard xcalc application
extended to allow replay.
This is done by adding the include file ``ReplayXt.h'' and the
call
.I RXt_RegisterPlayer(). 
This has a rules and data file hard-coded,
but these might be better set using application resources.
This has to be linked with either the ReplayXt or the ReplayXm library.

.SH "Motif example

A Motif example is given in the xmeditor directory.
This is the standard xmeditor example as given in the Motif distribution,
and has been made ``replay'' aware in the same manner as the Athena
application. 
This has to be linked with the ReplayXm library.

This example uses application resources so that the rules and data files
can be left to default values of ``replay.rules'' and ``replay.data'',
or specified by the command line options ``-rulesFile'' and
``-dataFile''. The option ``-verbose'' can also be used.

The next sections of this manual describe specific features of the
Motif widget set that are handled by this system.

For example, data to press and release a PushButton called ``btn''
with enough time to see that it has happened are
.PS
warpPointer btn 0 0             # move to corner of widget
callActionProc btn Arm()        # press the button
sleep 100      	                # sleep for one second
callActionProc btn Disarm() \\
    -type ButtonRelease \\
    -x 0 -y 0                   # release the button
.PE
The x and y coordinates are needed for the Disarm() action because these
are examined by Motif to determine whether or not the button release
occurred inside the widget. (If inside, the callbacks on the disarm
list are executed; if outside, they are not.)

The default files use these primitive commands. The file ``replay2.data''
uses the rules in the file ``motif.rules'', which is a preliminary
set of rules for Motif.

.SH List

The Motif List widget has the appearance of a set of items displayed
that can be individually or multiply selected. 
The appearance is of a group of objects.
The appearance is deceptive: there is no object structure.
This means that to select an item it is necessary to calculate
where the item is within the List, and to set x and y parameters
appropriately.

To perform this calculation, it is neccessary to find the number
of visible items and the height of the visible List.
For example, use a function such as:
.PS
proc indexToY {w n} {
  # calculate the Y co-ord for an index in the list
  getValues $w \\
    -height h -itemCount count \\
    -visibleItemCount vis \\
    -topItemPosition top

  set item_height [expr {$h / $vis}]
  set vis_index [expr {$n - $top + 1}]

  set y [expr {((2*$vis_index -1) * $item_height) / 2}]
  return $y
}

.PE

.SH Gadgets

Gadgets do not have windows and do not accept actions.
They are children of manager widgets such as Form, RowColumn, etc.
The manager widget is responsible for making the gadgets draw themselves
and respond to events. These are documented in the Motif man page for
XmManager.

To perform an action on a gadget, you need to firstly determine the
appropriate action on the manager. For example, to arm a gadget, the
action on the manager is
.I ManagerGadgetArm(). 
The way that Motif
determines that this action is for a particular gadget is
for the action to be located within
the gadget. So x and y coordinates must be determined for the widget
using
.I getValues, 
and then the action called with a type (eg ButtonPress)
and the x and y values.

.SH "Pulldown Menus

The top row of a pulldown menu is typically composed of CascadeButtons.
These have a specialised set of actions based on their designed use
in menus.
To press a cascade button, the action is
.I MenuBarSelect() 
and to release it the action is
.I DoSelect().

For ordinary PushButtons the normal actions used are
.I Arm(), Activate()
and
.I Disarm().
In a menu, these do not work.  Instead, use
.I BtnDown() 
to press the button, and
.I BtnUp() 
to release it.

The pulldown menu panes are not parented directly from the menubar,
but have an intervening popup shell. This is so that they can extend
beyond the boundaries of the menubar (they hang down from it).
Either you have to know the name of this popup shell, or use the
``*'' notation for widget path names. For example, use
.PS
main.menu_bar*menu_pane
.PE
to avoid needing the name of the parent popup of menu_pane.

.SH Dialogs

Dialogs are usually formed by using the convenience functions such as
.I XmCreatePromptDialog(). 
These usually use the SelectionBox or
MessageBox widgets. Note that the objects within these widgets are
all named. For example, the
.I Help 
button is called ``Help''. So if
you know the name of the selection box then the name of the
.I Help
button is formed from this by adding ``.Help''. It is not
neccessary to use functions such as
.I XmSelectionBoxGetChild().
The buttons are actually gadgets, so the manager action
functions have to be used on them.

The dialog also has a parent which is a popup shell. Again, it is
easiest to use the ``*'' notation for widget path names.


.SH Bugs
If two or more widgets have the same pathname, it is not possible
to distinguish between them.

Which widgets use what fields of what events is not documented
anywhere.

The Motif rules need to be made comprehensive, and someone should
write some for the Athena widget set.

Motif keyboard traversal does not work.

.SH Author
Jan Newmarch, University of Canberra, PO Box 1, Belconnen, ACT 2616,
Australia. Email: jan@ise.canberra.edu.au.
