
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

/*
 * This function copies standard input to "fd" and also copies
 * everythin from "fd" to standard output.
 * This is the 4.3BSD version that uses the select(2) system call.
 */
#include "myScreen.h"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#ifdef sparc
#include <termios.h>
#else
#include <linux/termios.h>
#endif
#include <unistd.h>
#ifndef sparc
#include <sys/ioctl.h>
#endif
#include "screen.h"

struct win myWindow;

void WriteString(
#if defined(__STDC__) || defined(__cplusplus)
	struct win*, char*, int
#endif
);

int err_sys();

void InitTerm (
#if defined(__STDC__) || defined(__cplusplus)
	int
#endif
);

int waitpid(
#if defined(__STDC__) || defined(__cplusplus)
int, void*, int
#endif
);

int writen(
#if defined(__STDC__) || defined(__cplusplus)
int, char*, int
#endif
);

int read(
#if defined(__STDC__) || defined(__cplusplus)
int, void*, unsigned int
#endif
);

int write(
#if defined(__STDC__) || defined(__cplusplus)
int, const void*, unsigned int
#endif
);

int wait(
#if defined(__STDC__) || defined(__cplusplus)
int, void*, int
#endif
);

void ResetScreen(
#if defined(__STDC__) || defined(__cplusplus)
struct win*
#endif
);

void InitTermcap();

void MakeNewEnv();

int assist(
#if defined(__STDC__) || defined(__cplusplus)
char*, int*, int, short*
#endif
);

int
select(
#if defined(__STDC__) || defined(__cplusplus)
int, struct fd_set *, struct fd_set *, struct fd_set *, struct timeval *
#endif
);

#ifdef __cplusplus
};
#endif

screen scr;
short tcl_in;
timeval timeoutArr, timeoutIarr, timeoutStdArr, timeoutStdIarr;

void
setTimeoutValues(int arrSec, long arrUsec, int iarrSec, long iarrUsec,
                 short std)
{
   if (std) {
      timeoutStdArr.tv_sec = arrSec;
      timeoutStdArr.tv_usec = arrUsec;
      timeoutStdIarr.tv_sec = iarrSec;
      timeoutStdIarr.tv_usec = iarrUsec;
   } else {
      timeoutArr.tv_sec = arrSec;
      timeoutArr.tv_usec = arrUsec;
      timeoutIarr.tv_sec = iarrSec;
      timeoutIarr.tv_usec = iarrUsec;
   }
}

void pass_all(int fd, int childpid)
{
   int           maxfdp1, nfound, nread, nwrite;
   char          in_line[MAX_LINE];
   char          out_line[MAX_LINE];
   char          inp[MAX_LINE];
   int           callback, longwait = 0, last_longwait = 0;
   fd_set        readmask;
   short read_tcl_data;
   timeval timeout;

   setTimeoutValues(0, long(500000), 0, long(300000), 0);
   setTimeoutValues(0, long(500000), 0, long(300000), 1);
   InitTermcap();
   InitTerm(0);
   MakeNewEnv();
   ResetScreen(&myWindow);
   FD_ZERO(&readmask);
   
   for ( ; ; ) {

      if (!tcl_in) {
	 if (!longwait)
	    FD_SET(0, &readmask);
	 FD_SET(fd, &readmask);
	 maxfdp1 = fd + 1;       /* check descriptors [0..fd] */

	 if (longwait) 
	    if (last_longwait)
	       timeout = timeoutIarr;
	    else
	       timeout = timeoutArr;
	 else {
	    timeout.tv_sec = 0;
	    timeout.tv_usec = 10000;
	 }	
	 
	 nfound = select(maxfdp1, &readmask, (void *) 0, (void *) 0,
			 &timeout);
	 if (nfound < 0)
	    err_sys("select error");
	 
	 nread = 0;
	 if (FD_ISSET(0, &readmask)) { /* data to read on stdin */
	    nread = read(0, in_line, MAX_LINE);
	    if (nread < 0)
	       err_sys("read error from stdin");
	    else if (nread == 0) {
	       waitpid(childpid, (void *) 0, 0);
	       break;          /* stdin EOF -> done */
	    }
	    in_line[nread] = '\0';
	    nwrite = 0;
	    out_line[nwrite] = '\0';
	 }
	 
	 nwrite = 0;
	 if (FD_ISSET(fd, &readmask)) {
	    /* data to read on stream pipe */
	    nwrite = read(fd, out_line, MAX_LINE);
	    if (nwrite <= 0) {
	       wait(childpid, (void *) 0, 0);
	       break;         /* error or EOF, terminate */
	    }
	    out_line[nwrite] = '\0';
	    nread = 0;
	    in_line[nread] = '\0';
	 } else if (longwait)
	    setTimeoutValues(timeoutStdArr.tv_sec, timeoutStdArr.tv_usec,
                             timeoutStdIarr.tv_sec, timeoutStdIarr.tv_usec, 0);
      }

      read_tcl_data = 0 == nread && 0 == nwrite && !longwait;
      
      if (0 == nread && 0 == nwrite) {
         short endCycle = 0;
	 tcl_in = assist(in_line, &nread, read_tcl_data, &endCycle);
         if (endCycle)
            scr.cycle = 0;
      }
      
      do {
	 callback = 0;
	 last_longwait = longwait;
	 if (nread != 0 || nwrite != 0 || longwait)
	    scr.process_line(in_line, &nread, out_line, &nwrite,
			     &callback, inp, &longwait);
	 if (nread != 0 && '\0' != in_line[0]) {
/*            if (longwait && last_longwait)
               sleep(5);*/
	    if (writen(fd, in_line, nread) != nread)
	       err_sys("writen error to stream pipe");
         }
	 if (nwrite != 0) {
	   WriteString(&myWindow, out_line, nwrite);
	   (void)fflush(stdout);
	 }
	 nwrite = 0;
	 if (callback) {
	    strcpy(&in_line[0], inp);
	    nread = strlen(in_line);
	 } else {
	    in_line[0] = '\0';
	    nread = 0;
	 }
      } while (callback);
   }
}

void
clear_tcl_in()
{
   tcl_in = 0;
}
