
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#include <memory.h>
#include <ctype.h>
#include <fstream.h>
#include <stdlib.h>
#include "agent.h"

static const int MAX_LINE = 8192;
static const int MAX_NAME = 200;
static const int MAX_DEF = 2000;
static const int MAX_DISP_HEIGHT = 132;
static const int MAX_DISP_WIDTH = 644;

class macro_link {
friend class screen;
   macro_link();
   mode macro_md;
   short valid;
   string* macroName;
   string* macro;
   string* context[MAX_CONTEXTS];
   macro_link* lexptr;
   macro_link* next;
   void empty();
};

class match_link {
friend class screen;
   macro_link* match;
   int count;
   match_link();
   match_link* next;
};

class screen {
   agent ag;
   agent_line_link* agent_scenario;
   short agent_active;
   short disp_width;
   short disp_height;
   mode curr_md;
   line_link* lines;
   int cd_mode;
   macro_link* in_macros;
   macro_link* out_macros;
   macro_link* new_macro;
   line_link* agent_ptr;
   short def_in;
   short def_out;
   short name_in;
   short name_out;
   short call_in;
   short erase_in;
   short kwrd_in;
   short pattern_in;
   string* patt_val;
   short def_agent;
   short def_branch;
   short alt_branch;
   short pick_alt_branch;
   short name_agent;
   string new_agent_name;
   string call_name;
   string erase_name;
   match_link* matches;
   short out_state;
   string sub_macro;
   short capture;
   string capt_str;
   short new_macro_defined;
   short macro_removed;
   short last_line;
   short curr_x;
   short curr_y;
   char disp[MAX_DISP_HEIGHT][MAX_DISP_WIDTH];
   short disp_inv[MAX_DISP_HEIGHT][MAX_DISP_WIDTH];
   short disp_und[MAX_DISP_HEIGHT][MAX_DISP_WIDTH];
   short inv_mode;
   short und_mode;
   short sel_line;
   short sel_line_nr;
   short sel_old_line;
   short sel_old_line_nr;
   short sel_area;
   short top_line;
   short top_pos;
   short bottom_line;
   short bottom_pos;
   short search;
   string search_pattern;
   short next_char_lit;
   short scr_clear;
   short save_x;
   short save_y;
   short scrollBegin;
   short scrollEnd;
   string reg[11];
   macro_link* ilexicon[128];
   macro_link* olexicon[128];
   short context_change;
   string* context[MAX_CONTEXTS];
   string* allcontexts;
   string* prevcontexts;
   short select_parent;
   long numCycles;
   agent_link* last_action;
   short timeout_in, timeout_state, timeout_std;
   int arrSec, iarrSec;
   long arrUsec, iarrUsec;
   int total_keywords;
   short kwrd_threshold_in;
   int kwrd_threshold;
   char kwrd_relation;
   short kwrd_line_cnt[MAX_DISP_HEIGHT];
   short add_context_in, context_in;
   macro_link* add_context_macro;
   short num_threshold_in;
   char num_comp_rel;
   int num_comp_val;
   int num_comp_threshold;
   void log_line(const mode, const char*& const, const int*,
		 const char*& const, const int*, char*&, int*);
   void init_lines();
   void del_lines();
   void init_macros();
   void save_macros();
   void init_matches();
   void insert_macro();
   void bdcpy(char*, const char*, int*);
   void show_blueprint(char*&, int*);
   void show_sel_line(char*&, int*);
   void show_sel_area(char*&, int*);
   void destroy_macros();
   int search_next_match(char*&, int*);
   void save_to_reg(int);
   public:
   short cycle;
   screen();
   void set_disp_width(int);
   void set_disp_height(int);
   void init_disp();
   void updateStatus();
   void process_line(char*&, int*, char*&, int*, int*, char*&, int*);
   short found_pattern(string*);
   void checkFromTimeToTime();
   ~screen();
};
