
/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 */

#include <fcntl.h>
#include "config.h"
#include "screen.h"
#include "ansi.h"
#include "extern.h"

extern int assume_LP;
extern int force_vt;
extern char **environ;
extern char* blank;
static char **NewEnv, Term[MAXSTR+5];
char *SockName;

extern void MakeNewEnv __P((void));

int assume_LP;
int force_vt;

void
#ifdef USEVARARGS
/*VARARGS2*/
# if defined(__STDC__)
Msg(int err, char *fmt, ...)
# else
Msg(err, fmt, va_alist)
int err;
char *fmt;
va_dcl
# endif
{
  static va_list ap = 0;
#else
/*VARARGS2*/
Msg(err, fmt, p1, p2, p3, p4, p5, p6)
int err;
char *fmt;
unsigned long p1, p2, p3, p4, p5, p6;
  {
#endif
  char buf[MAXPATH*2];
  char *p = buf;/*

  if (Detached)
    return;*/
#ifdef USEVARARGS
# if defined(__STDC__)
  va_start(ap, fmt);
# else
  va_start(ap);
# endif
  (void) vsprintf(p, fmt, ap);
  va_end(ap);
#else
  sprintf(p, fmt, p1, p2, p3, p4, p5, p6);
#endif
  if (err)
    {/*
      p += strlen(p);
      if (err > 0 && err < sys_nerr)
	sprintf(p, ": %s", sys_errlist[err]);
      else
	sprintf(p, ": Error %d", err);*/
    }/*
  if (HasWindow)
    {
      debug1("Msg('%s');\n", p);
      MakeStatus(buf);
    }
  else
    {
      printf("%s\r\n", buf);
      if (DeadlyMsg)
	{
          debug1("Msg('%s') screen is not up, exiting..\n", buf);
          Kill(AttacherPid, SIG_BYE);
          eexit(1);
	}
      else
	debug1("Harmless; Msg('%s');\n", buf);
    }
  DeadlyMsg = 1;*/
}

static int IsSymbol(e, s)
register char *e, *s;
{
  register char *p;
  register int n;

  for (p = e; *p && *p != '='; ++p)
    ;
  if (*p)
    {
      *p = '\0';
      n = strcmp(e, s);
      *p = '=';
      return n == 0;
    }
  return 0;
}

extern void MakeNewEnv()
{
  register char **op, **np;
  static char buf[MAXSTR];

  for (op = environ; *op; ++op)
    ;
  NewEnv = np = (char **) malloc((unsigned) (op - environ + 6 + 1) * sizeof(char **));
  if (!NewEnv)
    /*Msg_nomem*/;
#ifndef sparc
  if (strlen(SockName) > MAXSTR - 5)
#endif
    SockName = "?";
  sprintf(buf, "STY=%s", SockName);
  *np++ = buf;	                /* NewEnv[0] */
  *np++ = Term;	                /* NewEnv[1] */
#ifdef TIOCSWINSZ
  np += 2;	/* room for TERMCAP and WINDOW */
#else
  np += 4;	/* room for TERMCAP WINDOW LINES COLUMNS */
#endif

  for (op = environ; *op; ++op)
    {
      if (!IsSymbol(*op, "TERM") && !IsSymbol(*op, "TERMCAP")
	  && !IsSymbol(*op, "STY") && !IsSymbol(*op, "WINDOW")
	  && !IsSymbol(*op, "SCREENCAP")
#ifndef TIOCGWINSZ
	  && !IsSymbol(*op, "LINES") && !IsSymbol(*op, "COLUMNS")
#endif
	  )
	*np++ = *op;
    }
  *np = 0;
}

/* Send a terminal report as if it were typed. */ 
void
Report(wp, fmt, n1, n2)
struct win *wp;
char *fmt;
int n1, n2;
{/*
  register int n, len;
  char rbuf[40];

  sprintf(rbuf, fmt, n1, n2);
  len = strlen(rbuf);

  for (n = 0; n < MAXWIN; n++)
    {
      if (wp == wtab[n])
	{
	  if ((unsigned)(inlen[n] + len) <= sizeof *inbuf)
	    {
	      bcopy(rbuf, inbuf[n] + inlen[n], len);
	      if (inlen[n] == 0)
		inbuf_ct++;
	      inlen[n] += len;
	    }
	  break;
	}
    }*//* for */
}

void bclear(p, n)
int n;
char *p;
{
  bcopy(blank, p, n);
}
