#--------dv--------Menue zum  einstellen der Fensterfarben--------------------

# aus $DVHOME/layout/choosecolors.tcl benutzte Prozeduren:
#    hexcol,makeHr,makeHg, makeHb, buildhexlabel 
#
#
#----------------------------------------------------------------------------
# setwindowcolors {} Routine, die Fenster gemaess  den gesetzten Farbattributen
#                    setzt
#                    dp   : Diagrammdatensatz, in dem die Farbattribute
#                           stehen
#                    args : Startpfadliste der Fenster, die gefaerbt
#                           werden
#----------------------------------------------------------------------------
#
proc setwindowcolors {dp args} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # Breitensuche mit Startpunken "args"
   #
   while {$args != ""} {
      set widget [lvarpop args]
      lvarcat args [winfo children $widget]
 
      if {[string match *diagram.report.legend* $widget]} {
         
         # Bei  DiagrammLegenden und Legendenelementen nur Hintergrund setzen 
         #
         $widget config -background $diagdata($dp.backgroundcolor)
      } { 
         # widget gemaess dv-Standart-Farbklassen faeben
         #
         setwidgetcolor $widget\
                        $diagdata($dp.backgroundcolor)\
                        $diagdata($dp.foregroundcolor)\
                        $diagdata($dp.disabledcolor)\
                        $diagdata($dp.activecolor)\
                        $diagdata($dp.spotcolor)\
                        $diagdata($dp.insertioncolor)
      } ; # if
   } ; # while

  # Farbwerte in die Resource Datenbasis eintragen, damit nachtraeglich
  # geoeffnete Fenster ebenfalls die gewaehlten Farben darstellen 
  #
  setoptioncolors $diagdata($dp.backgroundcolor)\
                  $diagdata($dp.foregroundcolor)\
                  $diagdata($dp.disabledcolor)\
                  $diagdata($dp.activecolor)\
                  $diagdata($dp.spotcolor)\
                  $diagdata($dp.insertioncolor)
}

# ----------------------------------------------------------------------------
# updatesliders {} Hilfsroutine;
#               setzt die Slider, die r,g,b Farbfelder gemaess der Farbe
#               der aktuell gewaehlten Farbklasse im setwindowcolors Menue 
# ----------------------------------------------------------------------------
#
proc updatesliders {path dp} {

   # Statusvariablen sichtbar machen
   #
   global status

   # Farbwert der gewaehlten Farbklasse ermitteln
   #
   append class $status($dp.wincolorclassbuffer) buffer
   set color $status($dp.$class) 

   # r-g-b Werte ermitteln
   #
   set colors [hexcol $color]

   set r [lindex $colors 0]
   set g [lindex $colors 1]
   set b [lindex $colors 2]

   # setze Farben
   #
   makeHr $path $dp $r
   makeHg $path $dp $g
   makeHb $path $dp $b

   # setze Slider
   # 
   $path.r.slider set $r
   $path.g.slider set $g
   $path.b.slider set $b
}

# ----------------------------------------------------------------------------
# makewinHrgb {} Hifsroutine ; aktualisiert die Farbe des Demofensters im 
#               choosewincolors Menue
#               Kurventitels und die Hexadezimale Darstellung der Farbe
#               path : Pfad des diagcolorchoose Menues
#              dp   : aktueller Diagrammwidgetpfad
# ----------------------------------------------------------------------------
#
proc makewinHrgb {path dp} {

  # Statusvariablen sichtbar machen
  #
  global status

  # Stellung der Regler ermitteln
  #
  set rcol [format "%.2x" [$path.r.slider get]]
  set gcol [format "%.2x" [$path.g.slider get]]
  set bcol [format "%.2x" [$path.b.slider get]]

  # Hexadezimale Anzeige erneuern
  #
  $path.rgb.hexr configure -text "0x$rcol"
  $path.rgb.hexg configure -text "0x$gcol"
  $path.rgb.hexb configure -text "0x$bcol"

  # aktuelle Mischfarbe fuer die gewaehlte Farbklasse ermitteln
  #
  set rgbcol "#$rcol$gcol$bcol"

  # Mischfarbe abspeichern
  #
  set class $status($dp.wincolorclassbuffer)
  set status($dp.${class}buffer) $rgbcol

  # alle Demowidgets faerben
  #     (der Geschwindigkeit wegen Farben direkt setzen)
  #
  if { $class == "backgroundcolor" } then {
     # Background
     #
     $path.demo           configure -background $rgbcol
     $path.demo.l         configure -background $rgbcol
     $path.demo.l.list    configure -background $rgbcol
     $path.demo.l.scroll  configure -foreground $rgbcol
     $path.demo.b         configure -background $rgbcol
     $path.demo.b.check1  configure -background $rgbcol
     $path.demo.b.check2  configure -background $rgbcol
     $path.demo.e         configure -background $rgbcol
     $path.demo.e.label   configure -background $rgbcol

 } elseif { $class == "foregroundcolor" } then {
     # Foreground
     #
     $path.demo.l.list    configure -foreground $rgbcol
     $path.demo.l.list    configure -selectforeground $rgbcol
     $path.demo.b.check1  configure -foreground $rgbcol
     $path.demo.b.check2  configure -foreground $rgbcol
     $path.demo.e.label   configure -foreground $rgbcol
     $path.demo.e.entry   configure -foreground $rgbcol

 } elseif { $class == "activecolor" } then {
     # active background
     #
     $path.demo.l.scroll  configure -background $rgbcol
     $path.demo.l.scroll  configure -activeforeground $rgbcol
     $path.demo.b.check1  configure -activebackground $rgbcol
     $path.demo.b.check2  configure -activebackground $rgbcol
     $path.demo.l.list    configure -selectbackground $rgbcol
     $path.demo.e.entry   configure -selectbackground $rgbcol

 } elseif { $class == "spotcolor" } then {
     # signalcolor
     #
     $path.demo.b.check1  configure -selector $rgbcol
     $path.demo.b.check2  configure -selector $rgbcol

 } elseif { $class == "insertioncolor" } then {
     # Einfuegehintergrund
     #
     $path.demo.e.entry  configure -background $rgbcol

 } else {
     # disabled foreground
     #
     $path.demo.b.check2  configure -disabledforeground $rgbcol
 }
 update idletask
}
 
#-----------------------------------------------------------------------------
# fillwincolorsbuffer {} erstellt die Puffervariablen fuer das 
#                        choosewindowcolors Menue
#                        path : Pfad des choosewindowcolors Menue
#                        dp   : aktueller Diagrammdatensatz
#----------------------------------------------------------------------------
#
proc fillwincolorsbuffer {path dp} {

   # Diagramm und Statusvariablen sichtbar machen
   #
   global diagdata status

   set status($dp.wincolorclassbuffer)   $diagdata($dp.wincolorclass)
   set status($dp.foregroundcolorbuffer) $diagdata($dp.foregroundcolor)
   set status($dp.backgroundcolorbuffer) $diagdata($dp.backgroundcolor)
   set status($dp.disabledcolorbuffer)   $diagdata($dp.disabledcolor)
   set status($dp.activecolorbuffer)     $diagdata($dp.activecolor)
   set status($dp.spotcolorbuffer)       $diagdata($dp.spotcolor)
   set status($dp.insertioncolorbuffer)  $diagdata($dp.insertioncolor) 
}
 
#-----------------------------------------------------------------------------
# choosewindowcolorsok {} schreibt die Puffervariablen das choosewindowcolors
#                      Menue fest; faerbt alle Fenster und schreibt die
#                      Farbbelegung in die OptionsDatenbasis, damit neu
#                      geoeffnete Fenster ebenfalls die gewaehlte Farbe haben
#                      path : Pfad des choosewindowcolors Menue
#                      dp   : aktueller Diagrammdatensatz
#----------------------------------------------------------------------------- 
#
proc choosewindowcolorsok {path dp} {

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # Variablen zurueckschreiben
  #
  set diagdata($dp.wincolorclass)    $status($dp.wincolorclassbuffer)    
  set diagdata($dp.foregroundcolor)  $status($dp.foregroundcolorbuffer)
  set diagdata($dp.backgroundcolor)  $status($dp.backgroundcolorbuffer)
  set diagdata($dp.disabledcolor)    $status($dp.disabledcolorbuffer)  
  set diagdata($dp.activecolor)      $status($dp.activecolorbuffer)    
  set diagdata($dp.spotcolor)        $status($dp.spotcolorbuffer)      
  set diagdata($dp.insertioncolor)   $status($dp.insertioncolorbuffer) 

  # Fenster einfaerben
  #
  setwindowcolors $dp .

}

#-----------------------------------------------------------------------------
# buildradiobuttons {} Hifsroutine, die die Radiobuttons zur Auswahl der 
#                      Farbklasse erstellt
#                      path : Pfadname des choosewindowcolors Menues
#                      dp   : Name des aktuellen Datensatzes
#-----------------------------------------------------------------------------
#
proc buildradiobuttons {path dp} {

   # Statusvariablen sichtbar machen
   #
   global status

   # Rahmen fuer Radiobuttons erzeugen
   #
   frame $path.colorclass
   pack $path.colorclass 

      # Rahmen fuer linke  Gruppe der Radiobuttons erzeugen
      #
      frame $path.colorclass.buttonsleft
      pack $path.colorclass.buttonsleft -side left

         # radiobuttons erzeugen
         #
         radiobutton $path.colorclass.buttonsleft.foreground\
                     -text "Foreground"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value foregroundcolor\
                     -command "updatesliders $path $dp"\
                     -anchor w
        
         radiobutton $path.colorclass.buttonsleft.background\
                     -text "Background"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value backgroundcolor\
                     -command "updatesliders $path $dp"\
                     -anchor w
        
         radiobutton $path.colorclass.buttonsleft.disabled\
                     -text "disabled Foreground"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value disabledcolor\
                     -command "updatesliders $path $dp"\
                     -anchor w

         pack $path.colorclass.buttonsleft.foreground\
              $path.colorclass.buttonsleft.background\
              $path.colorclass.buttonsleft.disabled\
              -side top -fill x

      # Rahmen fuer rechte Gruppe der Radiobuttons erzeugen
      #
      frame $path.colorclass.buttonsright
      pack $path.colorclass.buttonsright -side left

         # radiobuttons erzeugen
         #
         radiobutton $path.colorclass.buttonsright.active\
                     -text "active Background"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value activecolor\
                     -command "updatesliders $path $dp"\
                     -anchor w
 
         radiobutton $path.colorclass.buttonsright.spot\
                     -text "spot Color"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value spotcolor\
                     -command "updatesliders $path $dp"\
                     -anchor w
   
         radiobutton $path.colorclass.buttonsright.insertion\
                     -text "insertion Background"\
                     -variable status($dp.wincolorclassbuffer)\
                     -value insertioncolor\
                     -command "updatesliders $path $dp"\
                     -anchor w

         pack $path.colorclass.buttonsright.active\
              $path.colorclass.buttonsright.spot\
              $path.colorclass.buttonsright.insertion\
              -side top -fill x
}
 
# ----------------------------------------------------------------------------
# builddemowindow {} Hilfsroutione; erstellt ein Demofenster fuer
#                    das choosewindowcolors Menue
#                    path: pfad des choosewindowcolors Menue
#                    dp  : aktueller Diagrammdatensatz
# ----------------------------------------------------------------------------
#
proc builddemowindow {path dp} {

  # Baue Demorahmen
  #
  frame $path.demo -relief sunken -bd 2 
  pack $path.demo -pady 10 

  # Listbox
  frame $path.demo.l 
  scrollbar $path.demo.l.scroll 
  listbox   $path.demo.l.list -relief sunken -geometry 12x2
  $path.demo.l.list insert end "Test"
  $path.demo.l.list insert end "Window"
  $path.demo.l.list select from 0
  $path.demo.l.list select to 0
  pack $path.demo.l.scroll -side right -fill y
  pack $path.demo.l.list   -side left
  pack $path.demo.l -padx 5 -pady 10 -side left -fill x

  # Buttons
  #
  frame $path.demo.b
  global status 
  set status($dp.demodummy) 1
  checkbutton $path.demo.b.check1 \
              -text "demo" -anchor w -variable status($dp.demodummy)
  checkbutton $path.demo.b.check2 -text "buttons" -anchor w -state disabled 
  pack $path.demo.b.check1 $path.demo.b.check2\
       -side top -fill x
  pack $path.demo.b -padx 5 -pady 10 -side left

  # Entry
  #
  frame $path.demo.e 
  label $path.demo.e.label -text "entry:"
  entry $path.demo.e.entry -width 10 -relief sunken
  $path.demo.e.entry insert end "colordemo"
  pack $path.demo.e.label $path.demo.e.entry -side left 
  pack $path.demo.e -padx 5 -side left 
}


# ----------------------------------------------------------------------------
# choosewindowcolors {} Menue, um Fensterfarben setzen zu koennen
#                    path: Pfadname des Fensters.
#                    dp  : Name des aktuellen Datensatzes
# ----------------------------------------------------------------------------
proc choosewindowcolors {path dp} {

  # Falls dieses Fenster schon offen ist, mache nichts mehr.
  #
  if {1 == [winfo exists $path]} {
     myraise $path
     return
  }

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status
 
  # Toplevelfenster erzeugen
  #
  toplevel $path

  # Rahmentitel setzen
  #
  set wintitle "[string toupper $diagdata($dp.frametitle)] Color Select Box"
  wm title $path $wintitle

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Choose

  # alten Focus sichern und focus auf auf dieses Toplevelfenster
  #
  savefocus
  focus $path

  # Fenster aufbauen---------------------------------------------------------

  # Titel setzen
  #
  label $path.title -text "Select Window Colors"
  pack $path.title -side top -pady 5

  # Radiobuttons fuer Kurventitel erzeugen
  #
  buildradiobuttons $path $dp

  # Hexadezimale Darstellung der MischFarbe
  #
  buildhexlabel $path $dp

  # Slider einbauen
  #
  buildsliders $path $dp "makewinHrgb $path $dp"
  pack $path.colors -side top -fill x

  # Demofenster einbauen
  #
  builddemowindow $path $dp
  
  # Knopfleiste erstellen
  #
  frame  $path.but
  pack $path.but -fill x -pady 10 

  button $path.but.ok -text " O K " \
         -command "destroy $path; busy {choosewindowcolorsok $path $dp}; \
                   setoldfocus"

  button $path.but.update -text "update"\
         -command "busy {choosewindowcolorsok $path $dp}" 

  button $path.but.cancel -text "Cancel"\
                      -command "destroy $path; setoldfocus"

  pack $path.but.ok $path.but.update $path.but.cancel\
       -side left -ipady 5 -padx 10 -fill x -expand true

  # Bindungen fuer Ok-Aktivierung durch 'Return' realisieren
  #
  bindreturn "[winfo children $path] $path" "$path.but.ok invoke"

  # Refreshprozedur erzeugen-------------------------------------------------
  #
  proc $path.refresh {path dp} {

     # erstelle Puffervariablen
     #
     fillwincolorsbuffer $path $dp

     # Setze Defaultwerte
     #
     updatesliders $path $dp

  } ; # refreshproc

  # zum initialisieren Refreshprozedur einmal aufrufen
  #
  $path.refresh $path $dp
}
