#---------------------dv--Hilfroutinen fuer Fileoperationen-------------------

#-----------------------------------------------------------------------------
# makepairlist {} Hilfsprozedur, die eine Liste in eine Liste von Listen
#                     mit zwei Elementen partitioniert.
#                     Beispiel : {1 2 3 4} wird zu {{1 2} {3 4}}
#                     Bei ungeraden Anzahlen von Elementen wird das letzte 
#                     Element nicht beruecksichtigt
#                     list : Eingabeliste
#                     return   gepaarte Liste
#-----------------------------------------------------------------------------
#
proc makepairlist {{list ""}} {

   # Kurvenliste auf gerade Anzahl von Elementen kuerzen
   #
   set ll [llength $list]
   if {[expr $ll % 2] != 0} {
      set list [lrange $list 0 [expr $ll-2]]
   }

   # Liste von Listen bilden
   #
   set i 0
   set plist ""
   foreach elem $list {
      if {[expr $i%2] == 0} {
         set dom $elem
      } {
         set cod $elem
         lappend plist [list $dom $cod]
      }
      incr i
   }
   return $plist      
}
   
#-----------------------------------------------------------------------------
# intersectpair {} Hilfsprozedur, die zwei Listen paarweise schneidet. Die 
#                  Listen werden zunaechst in Listen von Paaren partitioniert,
#                  dann geschnitten und das Ergebnis concateniert. Bei
#                  ungerader Anzahl von Elementen wird das letzte Element nicht
#                  beruecksichtigt.
#                  Beispiel : intersectpair {1 2 3 4} {1 2} -> {1 2}
#                             intersectpair {1 2 3 4} {2 3} -> {}
#                             intersectpair {1 2 3 4} {3 4} -> {3 4}
#                  list1 : 1 Liste
#                  list2 : 2 Liste
#                  return   Schnittliste
#---------------------------------------------------------------------------- 
#
proc intersectpair {{list1 ""} {list2 ""}} {
 
   set plist1 [makepairlist $list1]
   set plist2 [makepairlist $list2]
   set intersect [intersect $plist1 $plist2]
   set result [eval concat $intersect]
   return $result
}

#-----------------------------------------------------------------------------
# diagupdatelists {} passt Kurven bzw. Textlisten an einen geladenen 
#                    Datensatz an. Sind die Kurvenindizees im alten Datensatz
#                    gewaehlt und im neuen vorhanden, so werden sie im neuen
#                    Datensatz ebenfalls gewaehlt. Das heisst, es werden
#                    moeglichst die Kurvenzuordnungen des alten Datensatzes
#                    gewaehlt. 
#                    dp   : aktueller Datensatz
#                    db   : Datensatz, in den die Daten geladen wurden
#                    clist: Liste mit indizees aller Zahlenspalten 
#                    tlist: Liste mit indizees aller Textspalten
#-----------------------------------------------------------------------------
#
proc diagupdatelists {dp db clist tlist} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  # Kurvenliste fuer Modus domainindex anpassen
  #      
  set diagdata($db.curvelistindex)\
      [intersect $clist $diagdata($dp.curvelistindex)]

  # Kurvenliste fuer Modi != domainindex anpassen
  #
  set diagdata($db.curvelistreal)\
      [intersectpair $clist $diagdata($dp.curvelistreal)]
  set diagdata($db.curvelistdate)\
      [intersectpair $clist $diagdata($dp.curvelistdate)]
  set diagdata($db.curvelisttime)\
      [intersectpair $clist $diagdata($dp.curvelisttime)]

  # aktuelle Kurvenliste je nach domain anpassen
  #
  if {$diagdata($dp.domain) == "index"} {
      set diagdata($db.curvelist)\
          [intersect $clist $diagdata($dp.curvelist)]
  } {
      set diagdata($db.curvelist)\
          [intersectpair $clist $diagdata($dp.curvelist)]
  }

   # Textliste anpassen
   #
   set diagdata($db.textlist) [intersect $tlist $diagdata($dp.textlist)] 
}

#-----------------------------------------------------------------------------
# diagdatatype {} ermittelt Spaltentypen, Spaltentyplisten fuer einen 
#                 Datensatz und passt Kurven bzw. Textlisten an
#                 path : Datensatz, in dem Daten geladen wurde
#-----------------------------------------------------------------------------
#
proc diagdatatype {path} {
   
  # Diagrammdaten sichtbar machen
  #
  global diagdata

  # aktuelle Diagrammkennung
  #
  set dp $diagdata(diagram)

  # Kurven und Textliste inititalisieren 
  #
  set textlist ""
  set curvelist ""

  loop i 0 $diagdata($path.colnum) {

     # Spaltentyp ermitteln und abspeichern
     #
     set column $diagdata($path.col$i)

     if {[llength $column] <= 1} {
        # Spalte hat hoechstens einen Wert 1 =>
        # fuer korrekte Ermittlung des Spaltentyps per Minimumberechnung
        # zwei Nullen anhaengen 
        # (d.h. insbesondere : leere Spalten gelten als Zahlenspalten)
        #
        lvarcat column 0 0
     }

     # Die folgende Minimumberechning wird nur als Trick angewandt,
     # um festzustellen, ob alle Listenelemente numerisch sind
     #
     if {[catch "eval min $column"]} {
       
        # Spaltentyp ist text => Spaltenindex in textlist;
        #
        lappend textlist $i
        
        # Spaltentyp abspeichern
        #
        set diagdata($path.coltype$i) text
     } {
        # Spaltentyp ist number => Index der Spalte in Kurvenliste
        #
        lappend curvelist $i
        
        # Spaltentyp abspeichern
        #
        set diagdata($path.coltype$i) number
     }
  } ;# loop

  # Kurvenlisten fuer verschiedene Modi anpassen
  #
  diagupdatelists $dp $path $curvelist $textlist
} 

#-----------------------------------------------------------------------------
# diagdataget {} liest Daten in ein globales Array fuer die Darstellung in
#                einem Diagramm ein und ermittelt minimale und maximale
#                vorkommende Werte der Spalten sowie den Typ (text/numerisch)  
#                path : widget-Pfad des Diagramms, in dem die Daten
#                       dargestellt werden sollen
#-----------------------------------------------------------------------------
#
proc diagdataget {path} {

  # Feld, in dem die Daten einzulesen sind sichtbar machen 
  #
  global diagdata

  # aktuelle Diagrammkennung 
  #
  set dp $diagdata(diagram)

  set diagdata($path.status) undefined 

  # Datei mit Modus 'lesen' oeffnen
  #
  append file $diagdata($path.filepath) / $diagdata($path.filename)
  set f [open $file r]

  # Filegroesse feststellen
  #
  set fsize [file size $file]

  createloadview $dp\_main.loadview "File \"$diagdata($path.filename)\" loading..."

  # erste Zeile einlesen 
  #
  if {[gets $f line]<0} { 
      datageterr $diagdata($path.filename) 1

      # Anmerkung: hierhin wird nicht zurueckverzweigt
  }
  set diagdata($path.table) [list $line] ;# Zeile in Tabelle

  # Spaltenanzahl nach colnum und ins Diagrammdatenfeld 
  #
  set labels [concat $line]
  set colnum [llength $labels]
  set diagdata($path.colnum) $colnum

  # Spaltentitel in Diagrammdatenfeld
  #
  set i 0 
  foreach coltitle $labels {
     set diagdata($path.coltitle$i) $coltitle
     incr i
  }

  # zweite Zeile (Trennzeile) lesen
  #
  gets $f line
  lappend diagdata($path.table) $line ;# Zeile in Tabelle

  # Spaltenlisten initialisieren
  #
  loop i 0 $colnum { 
      set diagdata($path.col$i) "" 
  }

  # restlichen Zeilen einlesen; 
  #
  set lpos 3
  while {[gets $f line] >= 0} {

         if {[expr $lpos%20]  == 0 } {

           # jede 20'te Zeile Ladeanzeige aktualisieren
           #
           setloadview $dp\_main.loadview [tell $f] $fsize
         }
 
         lappend diagdata($path.table) $line ;# Zeile in Tabelle
	 set i 0
	 foreach colelem $line {

           # Spaltenelemente in zugehoerige Liste eintragen
           #
           lappend diagdata($path.col$i) $colelem
           incr i
	 }

         # Spaltenanzahl testen
         #
         if {$i != $colnum} { 
	    datageterr $diagdata($path.filename) $lpos 

	    # Anmerkung: hierhin wird nicht zurueckverzweigt
         }
         incr lpos
  }

  # Ladeanzeige auf voll setzen
  #
  setloadview $dp\_main.loadview 1 1

  # Zeilenanzahl abspeichern
  #
  set diagdata($path.rownum) [expr $lpos-1]

  # Datei schliessen
  #
  close $f

  # Ladeanzeige zerstoeren
  #
  destroyloadview $dp\_main.loadview

  # Spaltentypenlisten setzen
  # 
  diagdatatype $path 

  # Status sichern
  #
  set diagdata($path.status) defined
}

#-----------------------------------------------------------------------------
# diagdatacopy {} kopiert einen Diagrammdatensatz;
#                 source      : Quelldiagrammdatensatz
#                 destination : Zieldiagrammdatensatz
#-----------------------------------------------------------------------------
#
proc diagdatacopy {source destination} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # Liste mit source indizees ermitteln
   #
   set copylist [lmatch [array name diagdata] $source.*]

      foreach bufelem $copylist {

      # zugehoerigen (assotiativen) Index im aktuellen Datensatz ermitteln
      # 
      set i [string first . [crange $bufelem 1 end]]
      set index [crange $bufelem [expr $i+1] end] 

      # Element kopieren
      #
      set diagdata($destination$index) $diagdata($bufelem)

   } ; # foreach buffer
}

#-----------------------------------------------------------------------------
# copycol {} kopiert eine Datenspalte 
#            Einstellungen und Tabelle im Kartext werden nicht mitkopiert
#            source : Name des Quelldatensatzes
#            dest   : Name des Zieldatensatzes
#            sindex : Index der zu kopierenden Spalte im Quelldatensatz
#            dindex : Index der zu kopierenden Spalte im Zieldatensatz
#-----------------------------------------------------------------------------
#
proc copycol {source dest sindex dindex} { 

   # Diagrammvarablen sichtbar machen
   #
   global diagdata

   # Spalte kopieren
   #
   set diagdata($dest.col$dindex) $diagdata($source.col$sindex)
}

#-----------------------------------------------------------------------------
# copycolsblock {} kopiert einen Block von Datenspalten ; 
#             Einstellungen und die Tabelle im Klartext
#             werden nicht mitkopiert
#             source : Name des Quelldatensatzes
#             dest   : Name des Zieldatensatzes
#             sfrom  : Index der Startspalte im Quelldatensatz
#             sto    : Index der Endspalte im Quelldatensatz
#             dstart : Index der Startspalte im Ziehldatensatz
#----------------------------------------------------------------------------
#
proc copycolsblock {source dest sfrom sto dstart} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  # Spalten kopieren
  #
  set limit [expr $sto+1]
  loop i $sfrom $limit {
    copycol $source $dest $i [expr $i+$dstart]
  }
}

#-----------------------------------------------------------------------------
# copyallcols {} kopiert alle Spalten des Quelldatensatzes in den
#                Zieldatensatz
#                source : Name des Quelldatensatzes
#                dest   : Name des Zieldatensatzes
#-----------------------------------------------------------------------------
#
proc copyallcols {source dest} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   set maxindex [expr $diagdata($source.colnum) - 1] ;# maximaler Spaltenindex
   copycolsblock $source $dest 0 $maxindex 0         ;# Spalten kopieren
   set diagdata($dest.colnum) [expr $maxindex+1]     ;# neue Spaltenanzahl
                                                     ;# im Zieldatensatz
}

#-----------------------------------------------------------------------------
# appendallcols {} haengt alle Spalten des Quelldatensatzes an den
#                  Zieldatensatz an
#                  source : Name des Quelldatensatzes
#                  dest   : Name des Zieldatensatzes
#-----------------------------------------------------------------------------
#
proc appendallcols {dest source} {

    # Diagrammvariablen sichtbar machen
    #
    global diagdata

    set maxindex [expr $diagdata($source.colnum) - 1] ;# maximaler Spaltenindex
                                                      ;# im Quelldatensatz
    set appendindex $diagdata($dest.colnum)           ;# Startindex des Ziel
                                                      ;# Datensatzes
    copycolsblock $source $dest 0 $maxindex $appendindex
                                                      ;# Spalten kopieren
    set diagdata($dest.colnum) [expr $maxindex+$appendindex-1]
                                                      ;# neue Spaltenanzahl
                                                      ;# im Zield. speichern
}

#-----------------------------------------------------------------------------
# diagdatadelete {} loescht einen Diagrammdatensatz
#                 dp : zu loeschender Diagrammdatensatz
#-----------------------------------------------------------------------------
#
proc diagdatadelete {dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # Liste mit indizees des zu loeschenden Datensatzes ermitteln
   #
   set deletelist [lmatch [array name diagdata] $dp.*]

      foreach elem $deletelist {

      # Element loeschen 
      #
      unset diagdata($elem)

   } ; # foreach buffer
}

#----------------------------------------------------------------------------
# diagconfigget {} laedt eine Konfigurationsdatei, d.h. Einstellungen und
#                  Daten in den Konfigurationspuffer "configbuffer" ein
#                  path  : Pfad des diagramms, in dem der Konfigurationsname/
#                          Pfad steht
#                  buffer: name des Arrays, in das die Konfiguration eingeladen
#                          wird
#                  view  : [noloadview|showloadview]
#                          gibt an, ob eine Ladeanzeige gezeigt werden soll
#----------------------------------------------------------------------------
#
proc diagconfigget {path buffer {view showloadview}} {

  # Diagrammdaten sichtbar machen
  #
  global $buffer diagdata

  # akutelle Diagrammkennung
  #
  set dp $diagdata(diagram)

  # Datei mit Modus 'lesen' oeffnen
  #
  append file $diagdata($path.configpath) / $diagdata($path.configname)
  set f [open $file r]
 
  # Filegroesse feststellen
  #
  set fsize [file size $file]
 
  # Ladeanzeige erzeugen
  #
  if {$view == "showloadview"} {
  createloadview $dp\_main.loadview "File \"$diagdata($path.configname)\" loading..."
  }

  # este Zeile einlesen
  #
  gets $f line
  
  if {$line != "configuration_file"} {
      # file ist keine Konfigurationsdatei
      #
      noconfigerr $diagdata($path.configname) 

      # Anmerkung: hierhin wird nicht zurueckverzweigt
  } 

  # Konfiguration laden
  #
  set lpos 2
  while {[gets $f line] >= 0} {
        if {$view == "showloadview"} {
           if {[expr $lpos%20] == 0} { 
               # alle 20 Zeilen Ladeanzeige aktualisieren
               # 
               setloadview $dp\_main.loadview [tell $f] $fsize
           }
        }

        # Syntax ueberpruefen (Datei muss aus zwei Spalten bestehen)
        # 
        if {[llength $line] != 2} {
            configgeterr $diagdata($path.configname) $lpos

            # Anmerkung: hierhin wird nicht zurueckverzweigt
        }

         # Konfigurationsstrings zuordnen 
         #
         set [set buffer]([lindex $line 0]) [lindex $line 1]

         incr lpos
  }

  if {$view == "showloadview"} {
      # Ladeanzeige auf voll setzen
      # 
      setloadview $dp\_main.loadview 1 1
  }

  # Datei schliessen
  #
  close $f
 
  # Ladeanzeige zerstoeren
  #
  catch {destroyloadview $dp\_main.loadview}
}

#-----------------------------------------------------------------------------
# diagconfigfilter {} Hilfsfunktion, die feststellt, ob ein Konfigurations
#                     Element abgespeichert werden muss
#                     index: Index des Konfigurationselementes
#                     return 1 , falls Element abgespeichert werden muss
#                            0,  sonst
#-----------------------------------------------------------------------------
#
proc diagconfigfilter {index} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # Diagrammladepuffer nicht speichern
   #
   set buffer [string match .buffer* $index]

   # Zoomdiagrammdaten nicht speichern
   #
   set zoom [string match .zoom* $index]

   # Rueckgabewert: Wenn Indexelement weder Pufferelement, noch Zoomelement,
   #                dann muss es abgespeichert werden
   # 
   return [expr !($buffer || $zoom)]
}

#-----------------------------------------------------------------------------
# diagconfigput {} sichert die aktuelle Konfiguration, d.h. sichert 
#                  Einstellungen und Daten aller Diagramme
#                  configpath: Filepfad fuer die zu speichernde Konfiguration
#                  configname:  Filenamen fuer die zu speichernde Konfiguration
#-----------------------------------------------------------------------------
#
proc diagconfigput {configpath configname} {

  # Diagrammdaten sichtbar machen
  #
  global diagdata
 
  # akutelle Diagrammkennung
  #
  set dp $diagdata(diagram)

  # Datei mit Modus 'schreiben' oeffnen
  #
  append file $configpath / $configname
  set f [open $file w]

  # erwartete Zeilenanzahl der Datei feststellen
  #
  set size [array size diagdata]

  # Ladeanzeige erzeugen
  #
  createloadview $dp\_main.loadview "File \"$configname\" saving..."

  # Kennung apspeichern
  #
  puts $f "configuration_file"

  # Konfiguration abspeichern
  #
  set lpos 2
  for_array_keys line diagdata {

     if {[expr $lpos%20] == 0} {

        # alle 20 Zeilen Ladeanzeige aktualisieren
        #
        setloadview $dp\_main.loadview $lpos $size
     }

     if {[diagconfigfilter $line]} {
        # Konfigurationszeile abspeichern
        # 
        puts $f "$line \"$diagdata($line)\""
        incr lpos
     }
  }

  # Datei schliessen
  #
  close $f

  # Ladeanzeige auf voll setzen
  # 
  setloadview $dp\_main.loadview 1 1

  # Ladeanzeige zerstoeren
  #
  destroyloadview $dp\_main.loadview
}
      
#-----------------------------------------------------------------------------
# diagconfigcopy {} kopiert eine Konfiguration aus dem array source 
#                   in das array destination; 
#                   source      : Name des Quellarrays
#                   destination : name des Zielarrays
#-----------------------------------------------------------------------------
#
proc diagconfigcopy {source destination} {

   # Diagrammvariablen sichtbar machen
   #
   global $source $destination
  
   for_array_keys elem $source {
      
      # kopieren der Elemente
      #
      set [set destination]($elem) [set [set source]($elem)]
   }
}

#-----------------------------------------------------------------------------
# concattexttables {} Hilfsroutine, die zwei Tabellen textuell zusammenhaengt;
#                    die zweite Tabelle wird rechts neben die erste Tabelle
#                    gestellt und das Ergebnis in die erste Tabelle geschrieben
#                    dp     : widgetpfad des diagramms der ersten Tabelle
#                    buffer : widgetpfad des diagramms der zweiten Tabelle
#----------------------------------------------------------------------------
#
proc concattexttables {dp buffer} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # neue Tabelle in assotiatives array einlesen
   #
   set j 0
   foreach line $diagdata($buffer.table) {
      set bline($j) $line   
      incr j
   }

   # Tabellen zusammenbauen, dabei Tabellenformat beibehalten
   #
   set ll [clength $bline(0)] ;# Kopfbreite der alten Tabelle
   set lj [replicate " " $ll] ;# Leerstring in Kopfbreite der alten Tabelle

   # an alle alten Zeilen neue Zeilen anhaengen
   #
   set k 0
   foreach sline $diagdata($dp.table) {
     if {$k >= $j} {set bline($k) $lj}   ;# falls neue Tab. kuerzer als alte
     lappend rline "$sline$bline($k)" 
     incr k
   }
   # Falls neue Tabelle laenger als alte Tab.: Leerzeilen vorstellen 
   #
   set hl [lindex $diagdata($dp.table) 0];# 1.Zeile der neuen Tabelle
   set ll [clength $hl]                  ;# Kopfbreite der neuen Tabelle 
   set li [replicate " " $ll]            ;# Leerstring in Breite der neuen Tab.
   while {$k < $j} {
     lappend rline "$li$bline($k)"
     incr k
   }
   set diagdata($dp.table) $rline        ;# Tabelle zurueckschreiben
}

#------------------------------------------------------------------------------
#  concattabels {} Hilfsroutine, die zwei Tabellen zusammenhaengt; die zweite 
#                  Tabelle wird rechts neben die erste Tabelle gestellt und
#                  das Ergebnis in die erste Tabelle geschrieben
#                  dp     : widgetpfad des diagramms der ersten Tabelle
#                  buffer : widgetpfad des diagramms der zweiten Tabelle
#------------------------------------------------------------------------------
#                  
proc concattabels {dp buffer} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  loop col 0 $diagdata($buffer.colnum) {

      # ermittle Zielspalte im Diagrammdatensatz
      #
      set newcol [expr $col+$diagdata($dp.colnum)]

      # kopiere Titel in den Diagrammdatensatz
      # 
      set diagdata($dp.coltitle$newcol) $diagdata($buffer.coltitle$col)

      # kopiere Spaltentyp in den Diagrammdatensatz
      #
      set diagdata($dp.coltype$newcol) $diagdata($buffer.coltype$col)

      # kopiere Daten in den Diagrammdatensatz
      #
      set diagdata($dp.col$newcol) $diagdata($buffer.col$col)

   } ; # loop

   # neue Spaltenzahl ermitteln
   #
   set diagdata($dp.colnum) [expr $diagdata($dp.colnum)+\
                                  $diagdata($buffer.colnum)] 

   # neue Zeilenzahl ermitteln
   #
   set diagdata($dp.rownum) [max $diagdata($dp.rownum)\
                                  $diagdata($buffer.rownum)]

   # Tabelle auch textuell anhaengen-----------------------------
   #
   concattexttables $dp $buffer

   # Status des zusammengesetzten Datensatzes setzen
   #
   set diagdata($dp.status) "defined"
}
