^TI^Exception Values
^P^
In addition to the "normal" value returned by any execution of a Tcl 
command, each such command also returns an 
^I^exception code
. The exception code is normally 0, which indicates that the command 
just finished with was executed without any problem. In this case, the 
programmer/user of the program is usually never aware of the fact that 
the '0' exception is being returned. However, in addition to the normal 
'0' exception code, there are also exception codes for errors, and for 
other 'unusual' cases. Below is a list of exceptions codes by name, the
actual numeric value associated with each code (it may be useful to know 
these values when writing code containing commands such as 
^B^catch
, which make use of exception values), and a brief description of what 
exceptions of that type mean.
^P^
^B^TCL_OK
 = 0: The last command executed normally, without errors or exceptional 
circumstances.
^P^
^B^TCL_ERROR 
 = 1: An error of some sort occured.
^P^
^B^TCL_RETURN
 = 2: Issued by a 
^B^return
 command, to indicate the current procedure should return.
^P^
^B^TCL_BREAK
 = 3: Issued by a 
^B^break
 command, to indicate the innermost loop containing the bread should 
terminate its execution.
^P^
^B^TCL_CONTINUE
 = 4: Issued by a 
^B^continue
 command, to indicate that the remaining code in this iteration of the 
current loop should be skipped, and the next interation should be started 
immediately.