#
# This file contains the procedures for managing responses to articles.
# This includes things like the periodic editor-has-exited checker, and
# the procedure to parse the headers of the messages to determine context.
# 
# Author : Michael D. Moore
# 

proc parse_headers {file} {
    set tmpfile [safe_open $file "r"]
    gets $tmpfile line
    while {$line != ""} {
	if {[regexp {To: (.*)$} $line junk to]} {set To $to}
	if {[regexp {Subject: (.*)$} $line junk subj]} {set Subject $subj}
	if {[regexp {Newsgroups: (.*)$} $line junk g]} {set Groups $g}
	gets $tmpfile line
    }
    if {![info exists Groups]} {
	error_dialog "No newsgroup specified for posting... please edit the Newsgroups: field."
    }
	
    return [list $To $Subject $Groups]
}


proc do_post_article {group article file} {
    global Socket Resources

    if {$article != "original"} { 
	set answer [option_dialog .postquerry 800 "Followup Post Query" "Post response to article $article in $group?" Post Re-edit Cancel]
    } else {
	set answer [option_dialog .postquery 800 "Original Post Query" "Post article to $group?" Post Re-edit Cancel]
    }
    if {$answer == "Cancel"} {
	return 1
    }
    if {$answer == "Re-edit"} {
	return 0
    }
    interface_state wait
    write_scroll "Posting Article to $group....please wait..."
    if {![file exists $file]} {
	return 1
    }
    if {$Resources(POSTINGPROG)  != "nntp" && \
	$Resources(POSTINGPROG) != "NNTP"} {
	    set i [catch {set out [exec sh -c "$Resources(POSTINGPROG) $file"]} error]
	    if {$i} {	
		error_dialog "Error posting article : \n$error"
		interface_state normal
		return -1
	    }
	} else {
	    puts $Socket "post"
	    set file [open $file "r"]
	    while {[gets $file line] != -1} {
		puts $Socket $line
	    }
	    puts $Socket "."
	    flush $Socket
	    set code -1
	    while {$code != 240} {
		gets $Socket line
		scan $line "%d" code
		if {$code == 441} {
		    # article not posted -- more included text than new text...
		    write_brief "Article not posted.... more included text than new text..."
		    interface_state normal
		    return 1
		}
	    }
	}
    write_scroll "Article Posted..."
    interface_state normal
    return 1
}


proc mail_file {group article file} {
    global Options

#    parse_headers mail_file $group $article $file
    set answer [option_dialog .mailquerry 800 "Mail Reply Query" "Send mail response to article $article in group $group?" Send Re-edit Cancel]
    if {$answer == "Cancel"} {
	return 1
    }
    if {$answer == "Re-edit"} {
	return 0
    }
    set infile [open $file "r"]
    gets $infile line
    close $infile
    if {![regexp "To\: (.*)" $line junk email]} {
	error_dialog "Bad mail format... message not sent"
	return 1
    }
    exec sh -c "/usr/lib/sendmail -oo -oi -t < $file" &
    write_brief "Mail Message Sent..."
    return 1
}



proc check_for_posts {} {
    global PostingList Options Resources

    flush stdout
    if {$PostingList == {}} {
	flush stdout
	return
    }
    foreach entry $PostingList {
	set file "[lindex $entry 3].done"
	set type [lindex $entry 0]
	if {[file exists $file]} {
	    if {$type == "post"} {
		set i [lsearch $PostingList $entry]
		set PostingList [lreplace $PostingList $i $i]
		if {[do_post_article [lindex $entry 1] [lindex $entry 2] [lindex $entry 3]]} {
		    catch "exec rm [lindex $entry 3]"
		    catch "exec rm [lindex $entry 3].done"
		} else {
		    catch "exec rm [lindex $entry 3].done"
		    if {$Options(Gce)} {
			set i [catch {set out [exec /bin/sh -c "($Resources(gceEditor) [lindex $entry 3] ; /usr/bin/touch [lindex $entry 3].done) &" &]}]
		    } else {
			set i [catch {set out [exec /bin/sh -c "($Resources(EDITOR_COMMAND) [lindex $entry 3] ; /usr/bin/touch [lindex $entry 3].done) &" &]}]
		    }
		    if {$i} {
			write_scroll "ERROR -- $out"
		    }
		    lappend PostingList $entry
		}
	    }
	    if {$type == "mail"} {
		set i [lsearch $PostingList $entry]
		set PostingList [lreplace $PostingList $i $i]
		if {[mail_file [lindex $entry 1] [lindex $entry 2] [lindex $entry 3]]} {
		    exec rm [lindex $entry 3]
		    exec rm [lindex $entry 3].done
		} else {
		    exec rm [lindex $entry 3].done
		    exec /bin/sh -c "($Resources(EDITOR_COMMAND) [lindex $entry 3] ; /usr/bin/touch [lindex $entry 3].done) &" &
		    lappend PostingList $entry
		}
	    }
	}
    }
    after 3000 check_for_posts
}


