#!/usr/local/tcl/bin/tcl
#
# testpg:  a script to test the features of the page generator hack
#
loadlibindex /u/de/tcl/s/ucosyb.tlib
#
# These global variables should be set at the beginning so
# that page gen stuff will work
set pg_len 64
set pg_wid 80
set pg_pag 1
set pfp [open test.pg w]
#
# this will init a new blank page (default 80x66)
pg_init
#
# the args to pg_place are (required) line, col, text, format; 
# 			   (optional) break length/0, incr line (+/blank), header/blank
# Here we set up a  Header with date, text, page number
pg_place 1 1 "[fmtclock [getclock]]" %20s 0 {} HDR
pg_place 1 30 "This is the header text" %20s 0 {} HDR
pg_place 1 70 PNO %4d 0 {} HDR 
#
# The args to pg_line are line, col, length, direction, (optional) header/blank
pg_line 2 1 80 H HDR
#
# Now we set up a footer
pg_place 64 1 "This is the footer text" %20s 0 {} FTR
pg_place 64 70 PNO "Page %04d" 0 {} FTR
#
# Now we draw a vertical and a horizontal line just for grins
pg_line 16 10 20 H 
pg_line 7 10 20 V
#
# Now we place some text arbitrarily, demonstrating rightification and
# leftification
pg_place 3 15 Hello %-10.10s 
pg_place 4 15 World %-10.10s 
pg_place 5 15 Righty? %10.10s ?
pg_place 3 35 Hello2 %-10.10s 
pg_place 4 35 World2 %-10.10s 
pg_place 5 35 HO? %10.10s 
#
# This place command demonstrates the use of the text wrap feature;  the
# lengthy text will be word-wrapped to 25 chars and placed
pg_place 3 46 "Now is the time for all good droids to come to the aid of their party" %-25s 25
#
# Here we make an indivisible block (no page break in this block) using
# the block command
pg_place 59 3 "This line was printed without a break" %40s
pg_place 60 3 "-------------------------------------------- break" %45s 0 +
pg_block 60
# We could have done more elegantly:
# pg_block [pg_place 60 3 "--------------------------------------------" %45s 0 +]
# since pg_place always returns pg_lin
pg_place . 3  "This is the 1st line of an indivisible block" %45s 0 +
pg_place . 3  "This is the 2nd line of an indivisible block" %45s 0 +
pg_place . 3  "This is the 3rd line of an indivisible block" %45s 0 +
pg_place . 3  "This is the 4th line of an indivisible block" %45s 0 +
pg_place . 3  "--------------------------------------------" %45s
pg_block 0
#
# Here we ended the block.  Note that the block will try to walk off the page end,
# but will be prevented.
#
#
# Now we will try an ordinary page break, after making some table sorts
# of things in the middle
pg_line 10 5 65 H 
pg_line 12 5 65 H 
pg_line 14 5 65 H 
pg_line 16 5 65 H 
pg_line 18 5 65 H 
pg_line 20 5 65 H 
pg_line 10 5 10 V
pg_line 10 25 10 V
pg_line 10 35 10 V
pg_line 10 55 10 V
pg_line 10 70 10 V
pg_place 11 6 Value %5s
pg_place 13 36 23.456 %6.2f
pg_place 15 26 Hello! %6s
pg_place 17 56 Rightified %14.14s
pg_place 63 0 "This is the second to last line on the 2nd page" %40s 0 +
pg_place . 0 "This is the last line on the 2nd page" %40s 0 +
pg_place . 0 "And this little piggy should end up on page 3" %40s
#
pg_print 
#
close $pfp
# 
exit
#
