/*
 *  This file is a modified version of post-query.c which originates from NCSA
 *
 *  Modified by Wessel.Kraaij@let.ruu.nl to integrate POST method handling
 *  into tcl
 *
 *  Provided AS IS
 *
 *  3-5-1995
 */

#include "tcl.h"
#include <stdio.h>
#include <stdlib.h>

#define MAX_ENTRIES 10000

typedef struct {
    char *name;
    char *val;
} entry;

char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);


int www_parseargs(ClientData clientData, Tcl_Interp *interp,
              int argc, char *argv[]) {
    entry entries[MAX_ENTRIES];
    register int x,m=0;
    int cl;
    char command[100];
    char *oldvalue;
    /* sometimes a variable can hold 100 words of approx 20 chars */
/*    char newvalue[10000];  really should do dynamic allocation */
    char *newvalue;
    int result;
    int code;


   if (argc != 1) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }



    if(strcmp(getenv("REQUEST_METHOD"),"POST")) {
        printf("This script should be referenced with a METHOD of POST.\n");
        printf("If you don't understand this, see this ");
        printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c",10);
        exit(1);
    }
    if(strcmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded")) {
        printf("This script can only be used to decode form results. \n");
        exit(1);
    }
    cl = atoi(getenv("CONTENT_LENGTH"));


    for(x=0;cl && (!feof(stdin));x++) {
        m=x;
        entries[x].val = fmakeword(stdin,'&',&cl);
        plustospace(entries[x].val);
        unescape_url(entries[x].val);
        entries[x].name = makeword(entries[x].val,'=');
    }


    for(x=0; x <= m; x++)
	{


	   oldvalue = Tcl_GetVar2(interp,"cgi",entries[x].name,0);
	    if (oldvalue == NULL)
	      Tcl_SetVar2(interp,"cgi",entries[x].name,entries[x].val,0);
	    else
		{
		   Tcl_SetVar2(interp,"cgi",entries[x].name," ",TCL_APPEND_VALUE);
		   Tcl_SetVar2(interp,"cgi",entries[x].name,entries[x].val,TCL_APPEND_VALUE);
		}
	}
    return TCL_OK;
}   


int
WWW_Init(interp)
    Tcl_Interp *interp;
{
    
    Tcl_CreateCommand(interp, "www_getargs", www_parseargs,
                      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);


    return TCL_OK;
}
