'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/unsupported/latest/tk/doc/listbox.n,v 1.1 1993/01/24 04:59:46 zoo Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS listbox cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
listbox \- Create and manipulate listbox widgets
.SH SYNOPSIS
\fBlistbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBbackground\fR	\fBforeground\fR	\fBselectBackground\fR	\fBxScrollCommand\fR
\fBborderWidth\fR	\fBfont\fR	\fBselectBorderWidth\fR	\fByScrollCommand\fR
\fBcursor\fR	\fBgeometry\fR	\fBselectForeground\fR
\fBexportSelection\fR	\fBrelief\fR	\fBsetGrid\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
None.
.BE

.SH DESCRIPTION
.PP
The \fBlistbox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a listbox widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the listbox such as its colors, font,
text, and relief.  The \fBlistbox\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A listbox is a widget that displays a list of strings, one per line.
When first created, a new listbox has no elements in its list.
Elements may be added or deleted using widget commands described
below.  In addition, one or more elements may be selected as described
below.
.VS
If a listbox is exporting its selection (see \fBexportSelection\fR
option), then it will observe the standard X11 protocols
.VE
for handling the selection;  listbox selections are available
as type \fBSTRING\fR, consisting of a Tcl list with one entry
for each selected element.
.PP
For large lists only a subset of the list elements will be
displayed in the listbox window at once;  commands described below
may be used to change the view in the window.  Listboxes allow
.VS
scrolling in both directions using the standard \fBxScrollCommand\fR
and \fByScrollCommand\fR options.
.VE
They also support scanning, as described below.

.SH "WIDGET COMMAND"
.PP
The \fBlistbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for listbox widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlistbox\fR
command.
.TP
\fIpathName \fBcurselection\fR
.VS
Returns a list containing the indices of
all of the elements in the listbox that are currently selected.
If there are no elements selected in the listbox then an empty
string is returned.
.VE
.TP
\fIpathName \fBdelete \fIfirst \fR?\fIlast\fR?
Delete one or more elements of the listbox.  \fIFirst\fR and \fIlast\fR
give the integer indices of the first and last elements in the range
to be deleted.  If \fIlast\fR isn't specified it defaults to
\fIfirst\fR, i.e. a single element is deleted.  An index of
\fB0\fR corresponds to the first element in the listbox.  Either
\fIfirst\fR or \fIlast\fR may be specified as \fBend\fR, in which
case it refers to the last element of the listbox.  This command
returns an empty string
.TP
\fIpathName \fBget \fIindex\fR
Return the contents of the listbox element indicated by \fIindex\fR.
\fIIndex\fR must be a non-negative integer (0 corresponds to
the first element in the listbox), or it may also be specified as
\fBend\fR to indicate the last element in the listbox.
.TP
\fIpathName \fBinsert \fIindex \fR?\fIelement element ...\fR?
Insert zero or more new elements in the list just before the
element given by \fIindex\fR.  If \fIindex\fR is specified as
\fBend\fR then the new elements are added to the end of the
list.  Returns an empty string.
.TP
\fIpathName \fBnearest \fIy\fR
Given a y-coordinate within the listbox window, this command returns
the index of the (visible) listbox element nearest to that y-coordinate.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on listboxes.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
.VS
Records \fIx\fR and \fIy\fR and the current view in the listbox
window;  used in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
.VE
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBselect \fIoption arg\fR
This command is used to adjust the selection within a listbox.  It
has several forms, depending on \fIoption\fR.  In all of the forms
the index \fBend\fR refers to the last element in the listbox.
.RS
.TP
\fIpathName \fBselect adjust \fIindex\fR
Locate the end of the selection nearest to the element given by
\fIindex\fR, and adjust that end of the selection to be at \fIindex\fR
(i.e including but not going beyond \fIindex\fR).  The other
end of the selection is made the anchor point for future
\fBselect to\fR commands.  If the selection
isn't currently in the listbox, then this command is identical to
the \fBselect from\fR widget command.
Returns an empty string.
.TP
\fIpathName \fBselect clear\fR
.VS
If the selection is in this listbox then it is cleared so that
none of the listbox's elements are selected anymore.
.VE
.TP
\fIpathName \fBselect from \fIindex\fR
Set the selection to consist of element \fIindex\fR, and make
\fIindex\fR the anchor point for future \fBselect to\fR widget
commands.  Returns an empty string.
.TP
\fIpathName \fBselect to \fIindex\fR
Set the selection to consist of the elements from the anchor
point to element \fIindex\fR, inclusive.  The anchor point is
determined by the most recent \fBselect from\fR or \fBselect adjust\fR
command in this widget.  If the selection isn't in this widget,
this command is identical to \fBselect from\fR.
Returns an empty string.
.RE
.TP
\fIpathName \fBsize\fR
Returns a decimal string indicating the total number of elements
in the listbox.  Returns an empty string.
.TP
\fIpathName \fBxview \fIindex\fR
.VS
Adjust the view in the listbox so that character position \fIindex\fR
is displayed at the left edge of the widget.
Returns an empty string.
.TP
\fIpathName \fByview \fIindex\fR
Adjust the view in the listbox so that element \fIindex\fR is
displayed at the top of the widget.
If \fIindex\fR is specified as \fBend\fR it indicates the last
element of the listbox.  Returns an empty string.
.VE

.SH "DEFAULT BINDINGS"
.PP
.VS
Tk automatically creates class bindings for listboxes that give them
the following default behavior:
.IP [1]
When button 1 is pressed over a listbox, the element underneath the
mouse cursor is selected.  The mouse can be dragged to select a
range of elements.
.IP [2]
The ends of the selection can be adjusted by dragging with mouse
button 1 while the shift key is down;  this will adjust the end
of the selection that was nearest to the mouse cursor when button
1 was pressed.
.IP [3]
The view in the listbox can be adjusted by dragging with mouse button 2.
.PP
The behavior of listboxes can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
In addition, the procedure \fBtk_listboxSingleSelect\fR may be
invoked to change listbox behavior so that only a single element
may be selected at once.
.VE

.SH KEYWORDS
listbox, widget
