"proc tkTearOffMenu w {\n\
    # Find a unique name to use for the torn-off menu.  Find the first\n\
    # ancestor of w that is a toplevel but not a menu, and use this as\n\
    # the parent of the new menu.  This guarantees that the torn off\n\
    # menu will be on the same screen as the original menu.  By making\n\
    # it a child of the ancestor, rather than a child of the menu, it\n\
    # can continue to live even if the menu is deleted;  it will go\n\
    # away when the toplevel goes away.\n\
\n\
    set parent [winfo parent $w]\n\
    while {([winfo toplevel $parent] != $parent)\n\
	    || ([winfo class $parent] == \"Menu\")} {\n\
	set parent [winfo parent $parent]\n\
    }\n\
    if {$parent == \".\"} {\n\
	set parent \"\"\n\
    }\n\
    for {set i 1} 1 {incr i} {\n\
	set menu $parent.tearoff$i\n\
	if ![winfo exists $menu] {\n\
	    break\n\
	}\n\
    }\n\
\n\
    tkMenuDup $w $menu\n\
    $menu configure -transient 0\n\
\n\
    # Pick a title for the new menu by looking at the parent of the\n\
    # original: if the parent is a menu, then use the text of the active\n\
    # entry.  If it's a menubutton then use its text.\n\
\n\
    set parent [winfo parent $w]\n\
    switch [winfo class $parent] {\n\
	Menubutton {\n\
	    wm title $menu [$parent cget -text]\n\
	}\n\
	Menu {\n\
	    wm title $menu [$parent entrycget active -label]\n\
	}\n\
    }\n\
\n\
    $menu configure -tearoff 0\n\
    $menu post [winfo x $w] [winfo y $w]\n\
\n\
    # Set tkPriv(focus) on entry:  otherwise the focus will get lost\n\
    # after keyboard invocation of a sub-menu (it will stay on the\n\
    # submenu).\n\
\n\
    bind $menu <Enter> {\n\
	set tkPriv(focus) %W\n\
    }\n\
\n\
    # If there is a -tearoffcommand option for the menu, invoke it\n\
    # now.\n\
\n\
    set cmd [$w cget -tearoffcommand]\n\
    if {$cmd != \"\"} {\n\
	uplevel #0 $cmd $w $menu\n\
    }\n\
}",
"proc tkMenuDup {src dst} {\n\
    set cmd \"menu $dst\"\n\
    foreach option [$src configure] {\n\
	if {[llength $option] == 2} {\n\
	    continue\n\
	}\n\
	lappend cmd [lindex $option 0] [lindex $option 4]\n\
    }\n\
    eval $cmd\n\
    set last [$src index last]\n\
    if {$last == \"none\"} {\n\
	return\n\
    }\n\
    for {set i [$src cget -tearoff]} {$i <= $last} {incr i} {\n\
	set cmd \"$dst add [$src type $i]\"\n\
	foreach option [$src entryconfigure $i]  {\n\
	    lappend cmd [lindex $option 0] [lindex $option 4]\n\
	}\n\
	eval $cmd\n\
	if {[$src type $i] == \"cascade\"} {\n\
	    tkMenuDup [$src entrycget $i -menu] $dst.m$i\n\
	    $dst entryconfigure $i -menu $dst.m$i\n\
	}\n\
    }\n\
\n\
    # Duplicate the binding tags and bindings from the source menu.\n\
\n\
    regsub -all . $src {\\\\&} quotedSrc\n\
    regsub -all . $dst {\\\\&} quotedDst\n\
    regsub -all $quotedSrc [bindtags $src] $dst x\n\
    bindtags $dst $x\n\
    foreach event [bind $src] {\n\
	regsub -all $quotedSrc [bind $src $event] $dst x\n\
	bind $dst $event $x\n\
    }\n\
}",
