"proc tk_focusNext w {\n\
    set cur $w\n\
    while 1 {\n\
\n\
	# Descend to just before the first child of the current widget.\n\
\n\
	set parent $cur\n\
	set children [winfo children $cur]\n\
	set i -1\n\
\n\
	# Look for the next sibling that isn't a top-level.\n\
\n\
	while 1 {\n\
	    incr i\n\
	    if {$i < [llength $children]} {\n\
		set cur [lindex $children $i]\n\
		if {[winfo toplevel $cur] == $cur} {\n\
		    continue\n\
		} else {\n\
		    break\n\
		}\n\
	    }\n\
\n\
	    # No more siblings, so go to the current widget's parent.\n\
	    # If it's a top-level, break out of the loop, otherwise\n\
	    # look for its next sibling.\n\
\n\
	    set cur $parent\n\
	    if {[winfo toplevel $cur] == $cur} {\n\
		break\n\
	    }\n\
	    set parent [winfo parent $parent]\n\
	    set children [winfo children $parent]\n\
	    set i [lsearch -exact $children $cur]\n\
	}\n\
	if {($cur == $w) || [tkFocusOK $cur]} {\n\
	    return $cur\n\
	}\n\
    }\n\
}",
"proc tk_focusPrev w {\n\
    set cur $w\n\
    while 1 {\n\
\n\
	# Collect information about the current window's position\n\
	# among its siblings.  Also, if the window is a top-level,\n\
	# then reposition to just after the last child of the window.\n\
    \n\
	if {[winfo toplevel $cur] == $cur}  {\n\
	    set parent $cur\n\
	    set children [winfo children $cur]\n\
	    set i [llength $children]\n\
	} else {\n\
	    set parent [winfo parent $cur]\n\
	    set children [winfo children $parent]\n\
	    set i [lsearch -exact $children $cur]\n\
	}\n\
\n\
	# Go to the previous sibling, then descend to its last descendant\n\
	# (highest in stacking order.  While doing this, ignore top-levels\n\
	# and their descendants.  When we run out of descendants, go up\n\
	# one level to the parent.\n\
\n\
	while {$i > 0} {\n\
	    incr i -1\n\
	    set cur [lindex $children $i]\n\
	    if {[winfo toplevel $cur] == $cur} {\n\
		continue\n\
	    }\n\
	    set parent $cur\n\
	    set children [winfo children $parent]\n\
	    set i [llength $children]\n\
	}\n\
	set cur $parent\n\
	if {($cur == $w) || [tkFocusOK $cur]} {\n\
	    return $cur\n\
	}\n\
    }\n\
}",
"proc tkFocusOK w {\n\
    set code [catch {$w cget -takefocus} value]\n\
    if {($code == 0) && ($value != \"\")} {\n\
	if {$value == 0} {\n\
	    return 0\n\
	} elseif {$value == 1} {\n\
	    return [winfo viewable $w]\n\
	} else {\n\
	    set value [uplevel #0 $value $w]\n\
	    if {$value != \"\"} {\n\
		return $value\n\
	    }\n\
	}\n\
    }\n\
    if {![winfo viewable $w]} {\n\
	return 0\n\
    }\n\
    set code [catch {$w cget -state} value]\n\
    if {($code == 0) && ($value == \"disabled\")} {\n\
	return 0\n\
    }\n\
    regexp Key|Focus \"[bind $w] [bind [winfo class $w]]\"\n\
}",
"proc tk_focusFollowsMouse {} {\n\
    set old [bind all <Enter>]\n\
    set script {\n\
	if {(\"%d\" == \"NotifyAncestor\") || (\"%d\" == \"NotifyNonlinear\")\n\
		|| (\"%d\" == \"NotifyInferior\")} {\n\
	    if [tkFocusOK %W] {\n\
		focus %W\n\
	    }\n\
	}\n\
    }\n\
    if {$old != \"\"} {\n\
	bind all <Enter> \"$old; $script\"\n\
    } else {\n\
	bind all <Enter> $script\n\
    }\n\
}",
