"proc tk_dialog {w title text bitmap default args} {\n\
    global tkPriv\n\
\n\
    # 1. Create the top-level window and divide it into top\n\
    # and bottom parts.\n\
\n\
    catch {destroy $w}\n\
    toplevel $w -class Dialog\n\
    wm title $w $title\n\
    wm iconname $w Dialog\n\
    wm protocol $w WM_DELETE_WINDOW { }\n\
\n\
    # The following command has been removed because if it is present\n\
    # the dialog won't be posted if [winfo parent $w] is iconified.\n\
\n\
    frame $w.bot -relief raised -bd 1\n\
    pack $w.bot -side bottom -fill both\n\
    frame $w.top -relief raised -bd 1\n\
    pack $w.top -side top -fill both -expand 1\n\
\n\
    # 2. Fill the top part with bitmap and message (use the option\n\
    # database for -wraplength so that it can be overridden by\n\
    # the caller).\n\
\n\
    option add *Dialog.msg.wrapLength 3i widgetDefault\n\
    label $w.msg -justify left -text $text\n\
    catch {$w.msg configure -font \\\n\
		-Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*\n\
    }\n\
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m\n\
    if {$bitmap != \"\"} {\n\
	label $w.bitmap -bitmap $bitmap\n\
	pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m\n\
    }\n\
\n\
    # 3. Create a row of buttons at the bottom of the dialog.\n\
\n\
    set i 0\n\
    foreach but $args {\n\
	button $w.button$i -text $but -command \"set tkPriv(button) $i\"\n\
	if {$i == $default} {\n\
	    frame $w.default -relief sunken -bd 1\n\
	    raise $w.button$i $w.default\n\
	    pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m\n\
	    pack $w.button$i -in $w.default -padx 2m -pady 2m\n\
	} else {\n\
	    pack $w.button$i -in $w.bot -side left -expand 1 \\\n\
		    -padx 3m -pady 2m\n\
	}\n\
	incr i\n\
    }\n\
\n\
    # 4. Create a binding for <Return> on the dialog if there is a\n\
    # default button.\n\
\n\
    if {$default >= 0} {\n\
	bind $w <Return> \"\n\
	    $w.button$default configure -state active -relief sunken\n\
	    update idletasks\n\
	    after 100\n\
	    set tkPriv(button) $default\n\
	\"\n\
    }\n\
\n\
    # 5. Withdraw the window, then update all the geometry information\n\
    # so we know how big it wants to be, then center the window in the\n\
    # display and de-iconify it.\n\
\n\
    wm withdraw $w\n\
    update idletasks\n\
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n\
	    - [winfo vrootx [winfo parent $w]]]\n\
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n\
	    - [winfo vrooty [winfo parent $w]]]\n\
    wm geom $w +$x+$y\n\
    wm deiconify $w\n\
\n\
    # 6. Set a grab and claim the focus too.\n\
\n\
    set oldFocus [focus]\n\
    set oldGrab [grab current $w]\n\
    if {$oldGrab != \"\"} {\n\
	set grabStatus [grab status $oldGrab]\n\
    }\n\
    grab $w\n\
    if {$default >= 0} {\n\
	focus $w.button$default\n\
    } else {\n\
	focus $w\n\
    }\n\
\n\
    # 7. Wait for the user to respond, then restore the focus and\n\
    # return the index of the selected button.  Restore the focus\n\
    # before deleting the window, since otherwise the window manager\n\
    # may take the focus away so we can't redirect it.  Finally,\n\
    # restore any grab that was in effect.\n\
\n\
    tkwait variable tkPriv(button)\n\
    catch {focus $oldFocus}\n\
    destroy $w\n\
    if {$oldGrab != \"\"} {\n\
	if {$grabStatus == \"global\"} {\n\
	    grab -global $oldGrab\n\
	} else {\n\
	    grab $oldGrab\n\
	}\n\
    }\n\
    return $tkPriv(button)\n\
}",
