'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) pixmap.n 1.10 96/03/29 14:48:41
'\" 
.so man.macros
.TH pixmap n 4.1 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pixmap \- Images that display two or more colors
.SH SYNOPSIS
\fBimage create pixmap \fR?\fIname\fR? ?\fIoptions\fR?
.BE

.SH DESCRIPTION
.PP
A pixmap is an image whose pixels can display two or more colors
or be transparent.

.SH "CREATING BITMAPS"
.PP
Like all images, pixmaps are created using the \fBimage create\fR
command.
Bitmaps support the following \fIoptions\fR:
.TP
\fB\-data \fIstring\fR
Specifies the contents of the source pixmap as a string.
The string must adhere to X11 pixmap format (e.g., as generated
by the \fBpixmap\fR program).
If both the \fB\-data\fR and \fB\-file\fR options are specified,
the \fB\-data\fR option takes precedence.
.TP
\fB\-file \fIname\fR
\fIname\fR gives the name of a file whose contents define the
source pixmap.
The file must adhere to X11 pixmap format (e.g., as generated
by the \fBpixmap\fR program).
.TP

.SH "IMAGE COMMAND"
.PP
When a pixmap image is created, Tk also creates a new command
whose name is the same as the image.
This command may be used to invoke various operations
on the image.
It has the following general form:
.CS
\fIimageName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for pixmap images:
.TP
\fIimageName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBimage create pixmap\fR command.
.TP
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options for the image.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the
\fBimage create pixmap\fR command.

.SH KEYWORDS
pixmap, image
