'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) bell.n 1.8 96/03/26 18:19:55
'\" 
.so man.macros
.TH bell n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bell \- Ring a display's bell
.SH SYNOPSIS
\fBbell \fR?\fB\percent\fR? \fR?\fB\-displayof \fIwindow\fR?
.BE

.SH DESCRIPTION
.PP
This command rings the bell on the display for \fIwindow\fR and
returns an empty string.  \fIpercent\fR is relative to the base
volume of the keyboard bell and can range from -100 to 100
inclusive.
.PP
If \fIpercent\fR is nonnegative then the bell volume is:
.DS C
base - [(base * \fIpercent\fR) / 100] + \fIpercent\fR
.DE
If \fIpercent\fR is negative then the bell volume is:
.DS C
base + [(base * \fIpercent\fR) / 100]
.DE
\fIpercent\fR defaults to 0 if it is not specified
.PP
If the \fB\-displayof\fR option is omitted, the display of the
application's main window is used by default.
The command uses the current bell-related settings for the display, which
may be modified with programs such as \fBxset\fR.
.PP
This command also resets the screen saver for the screen.  Some
screen savers will ignore this, but others will reset so that the
screen becomes visible again.

.SH KEYWORDS
beep, bell, ring
