/* 
 * tclLoadShl.c --
 *
 *	This file implements the dlopen and dlsym APIs under the
 *	HP-UX operating system, to enable the Tcl "load" command to
 *	work.  This code was provided by Jan Nijtmans.
 *
 * SCCS: @(#) tclLoadShl.c 1.5 96/03/15 15:01:44
 */

#include <dl.h>

/*
 * On some HP machines, dl.h defines EXTERN; remove that definition.
 */

#ifdef EXTERN
#   undef EXTERN
#endif

#include "tcl.h"
#include "tclPort.h"
#include "../compat/dlfcn.h"

VOID *dlopen(path, mode)
    CONST char *path;
    int mode;
{
    return (VOID *) shl_load(path, BIND_IMMEDIATE, 0L);
}

VOID *dlsym(handle, symbol)
    VOID *handle;
    CONST char *symbol;
{   VOID *procPtr;

    if (shl_findsym((shl_t *)&handle, symbol, (short) TYPE_PROCEDURE, &procPtr)
	    != 0) {
	procPtr = NULL;
    }
    return procPtr;
}

char *dlerror()
{
    return Tcl_ErrnoMsg(errno);
}
