"if {[info commands package] == \"\"} {\n\
    error \"version mismatch: library\\nscripts expect Tcl version 7.5b1 or later but the loaded version is\\nonly [info patchlevel]\"\n\
}",
"package require -exact Tcl 7.5",
"if [catch {set auto_path $env(TCLLIBPATH)}] {\n\
    if [file exists [file join [file dirname [info nameofexecutable]] pkgIndex.tcl]] {\n\
	set auto_path [file dirname [info nameofexecutable]]\n\
    } elseif [file exists [file join [file dirname [file dirname [info nameofexecutable]]] lib pkgIndex.tcl]] {\n\
	set auto_path [file join [file dirname [file dirname [info nameofexecutable]]] lib]\n\
    } else {\n\
	set auto_path \"\"\n\
    }\n\
}",
"if {([info library]!=\"\") && ([lsearch -exact $auto_path [info library]] < 0)} {\n\
    lappend auto_path [info library]\n\
}",
"package unknown tclPkgUnknown",
"if {[info commands exec] == \"\"} {\n\
    # Some machines, such as the Macintosh, do not have exec \n\
    set auto_noexec 1\n\
}",
"set errorCode \"\"",
"set errorInfo \"\"",
"set unknown_handler_order {}",
"proc unknown {args} {\n\
    global unknown_handler_order unknown_handlers errorInfo errorCode\n\
\n\
    foreach handler $unknown_handler_order {\n\
        set status [catch {uplevel $unknown_handlers($handler) $args} result]\n\
\n\
        if {$status == 1} {\n\
            #\n\
            # Strip the last five lines off the error stack (they're\n\
            # from the \"uplevel\" command).\n\
            #\n\
            set new [split $errorInfo \\n]\n\
            set new [join [lrange $new 0 [expr [llength $new] - 6]] \\n]\n\
            return -code $status -errorcode $errorCode \\\n\
                -errorinfo $new $result\n\
\n\
        } elseif {$status != 4} {\n\
            return -code $status $result\n\
        }\n\
    }\n\
\n\
    set name [lindex $args 0]\n\
    return -code error \"invalid command name \\\"$name\\\"\"\n\
}",
"proc unknown_handler {name args} {\n\
    global unknown_handler_order unknown_handlers\n\
\n\
    set unknown_handlers($name) $args\n\
    set unknown_handler_order [linsert $unknown_handler_order 0 $name]\n\
}",
"unknown_handler \"tcl\" tcl_unknown",
"proc tcl_unknown args {\n\
    global auto_noexec auto_noload env unknown_pending tcl_interactive\n\
    global errorCode errorInfo\n\
\n\
    # Save the values of errorCode and errorInfo variables, since they\n\
    # may get modified if caught errors occur below.  The variables will\n\
    # be restored just before re-executing the missing command.\n\
\n\
    set savedErrorCode $errorCode\n\
    set savedErrorInfo $errorInfo\n\
    set name [lindex $args 0]\n\
    if ![info exists auto_noload] {\n\
	#\n\
	# Make sure we're not trying to load the same proc twice.\n\
	#\n\
	if [info exists unknown_pending($name)] {\n\
	    unset unknown_pending($name)\n\
	    if {[array size unknown_pending] == 0} {\n\
		unset unknown_pending\n\
	    }\n\
	    return -code error \"self-referential recursion in \\\"unknown\\\" for command \\\"$name\\\"\";\n\
	}\n\
	set unknown_pending($name) pending;\n\
	set ret [catch {auto_load $name} msg]\n\
	unset unknown_pending($name);\n\
	if {$ret != 0} {\n\
	    return -code $ret -errorcode $errorCode \\\n\
		\"error while autoloading \\\"$name\\\": $msg\"\n\
	}\n\
	if ![array size unknown_pending] {\n\
	    unset unknown_pending\n\
	}\n\
	if $msg {\n\
	    set errorCode $savedErrorCode\n\
	    set errorInfo $savedErrorInfo\n\
	    set code [catch {uplevel $args} msg]\n\
	    if {$code ==  1} {\n\
		#\n\
		# Strip the last five lines off the error stack (they're\n\
		# from the \"uplevel\" command).\n\
		#\n\
\n\
		set new [split $errorInfo \\n]\n\
		set new [join [lrange $new 0 [expr [llength $new] - 6]] \\n]\n\
		return -code error -errorcode $errorCode \\\n\
			-errorinfo $new $msg\n\
	    } else {\n\
		return -code $code $msg\n\
	    }\n\
	}\n\
    }\n\
    if {([info level] == 1) && ([info script] == \"\") \\\n\
	    && [info exists tcl_interactive] && $tcl_interactive} {\n\
	if ![info exists auto_noexec] {\n\
	    if [auto_execok $name] {\n\
		set errorCode $savedErrorCode\n\
		set errorInfo $savedErrorInfo\n\
		return [uplevel exec >&@stdout <@stdin $args]\n\
	    }\n\
	}\n\
	set errorCode $savedErrorCode\n\
	set errorInfo $savedErrorInfo\n\
	if {$name == \"!!\"} {\n\
	    return [uplevel {history redo}]\n\
	}\n\
	if [regexp {^!(.+)$} $name dummy event] {\n\
	    return [uplevel [list history redo $event]]\n\
	}\n\
	if [regexp {^\\^([^^]*)\\^([^^]*)\\^?$} $name dummy old new] {\n\
	    return [uplevel [list history substitute $old $new]]\n\
	}\n\
	set cmds [info commands $name*]\n\
	if {[llength $cmds] == 1} {\n\
	    return [uplevel [lreplace $args 0 0 $cmds]]\n\
	}\n\
	if {[llength $cmds] != 0} {\n\
	    if {$name == \"\"} {\n\
		return -code error \"empty command name \\\"\\\"\"\n\
	    } else {\n\
		return -code error \\\n\
			\"ambiguous command name \\\"$name\\\": [lsort $cmds]\"\n\
	    }\n\
	}\n\
    }\n\
    return -code error \"invalid command name \\\"$name\\\"\"\n\
}",
"proc auto_load cmd {\n\
    global auto_index auto_oldpath auto_path env errorInfo errorCode\n\
\n\
    if {[info exists auto_index($cmd)]} {\n\
        set loadcmd $auto_index($cmd)\n\
    } else {\n\
        foreach nsref [uplevel import all] {\n\
            set ns [lindex $nsref 0]\n\
			if {$ns == \"::\"} {\n\
            	set fullname \"::$cmd\"\n\
			} else {\n\
            	set fullname \"$ns::$cmd\"\n\
			}\n\
            if {[info exists auto_index($fullname)]} {\n\
                set loadcmd $auto_index($fullname)\n\
                break\n\
            }\n\
        }\n\
    }\n\
    if {[info exists loadcmd]} {\n\
	uplevel #0 $loadcmd\n\
	return [expr {[info which $cmd] != \"\"}]\n\
    }\n\
\n\
    if [catch {set path $auto_path}] {\n\
	if [catch {set path $env(TCLLIBPATH)}] {\n\
	    if [catch {set path [info library]}] {\n\
		return 0\n\
	    }\n\
	}\n\
    }\n\
\n\
    if [info exists auto_oldpath] {\n\
	if {$auto_oldpath == $auto_path} {\n\
	    return 0\n\
	}\n\
    }\n\
    set auto_oldpath $auto_path\n\
    for {set i [expr [llength $auto_path] - 1]} {$i >= 0} {incr i -1} {\n\
	set dir [lindex $auto_path $i]\n\
	set f \"\"\n\
	if [catch {set f [open [file join $dir tclIndex]]}] {\n\
	    continue\n\
	}\n\
	set error [catch {\n\
	    set id [gets $f]\n\
	    if {$id == \"# Tcl autoload index file, version 2.0\" ||\n\
		$id == \"# Tcl autoload index file, version 2.0 for \\[incr Tcl\\]\"} {\n\
		eval [read $f]\n\
	    } elseif {$id == \"# Tcl autoload index file: each line identifies a Tcl\"} {\n\
		while {[gets $f line] >= 0} {\n\
		    if {([string index $line 0] == \"#\")\n\
			    || ([llength $line] != 2)} {\n\
			continue\n\
		    }\n\
		    set name [lindex $line 0]\n\
		    set auto_index($name) \\\n\
			\"source [file join $dir [lindex $line 1]]\"\n\
		}\n\
	    } else {\n\
		error \"[file join $dir tclIndex] isn't a proper Tcl index file\"\n\
	    }\n\
	} msg]\n\
	if {$f != \"\"} {\n\
	    close $f\n\
	}\n\
	if $error {\n\
	    error $msg $errorInfo $errorCode\n\
	}\n\
    }\n\
    if {[info exists auto_index($cmd)]} {\n\
        set loadcmd $auto_index($cmd)\n\
    } else {\n\
        foreach nsref [uplevel import all] {\n\
            set ns [lindex $nsref 0]\n\
			if {$ns == \"::\"} {\n\
            	set fullname \"::$cmd\"\n\
			} else {\n\
            	set fullname \"$ns::$cmd\"\n\
			}\n\
            if {[info exists auto_index($fullname)]} {\n\
                set loadcmd $auto_index($fullname)\n\
                break\n\
            }\n\
        }\n\
    }\n\
    if {[info exists loadcmd]} {\n\
	uplevel #0 $loadcmd\n\
	return [expr {[info which $cmd] != \"\"}]\n\
    }\n\
    return 0\n\
}",
"if {[string compare $tcl_platform(platform) windows] == 0} {\n\
\n\
\n\
proc auto_execok name {\n\
    global auto_execs env\n\
\n\
    if [info exists auto_execs($name)] {\n\
	return $auto_execs($name)\n\
    }\n\
    set auto_execs($name) 0\n\
    if {[file pathtype $name] != \"relative\"} {\n\
	foreach ext {.exe .bat .cmd} {\n\
	    if {[file exists ${name}${ext}]\n\
		&& ![file isdirectory ${name}${ext}]} {\n\
		set auto_execs($name) 1\n\
	    }\n\
	}\n\
	return $auto_execs($name)\n\
    }\n\
    if {! [info exists env(PATH)]} {\n\
	if [info exists env(Path)] {\n\
	    set path $env(Path)\n\
	} else {\n\
	    return 0\n\
	}\n\
    } else {\n\
	set path $env(PATH)\n\
    }\n\
    foreach dir [split $path {;}] {\n\
	if {$dir == \"\"} {\n\
	    set dir .\n\
	}\n\
	foreach ext {.exe .bat .cmd} {\n\
	    set file [file join $dir ${name}${ext}]\n\
	    if {[file exists $file] && ![file isdirectory $file]} {\n\
		set auto_execs($name) 1\n\
		return 1\n\
	    }\n\
	}\n\
    }\n\
    return 0\n\
}\n\
\n\
} else {\n\
\n\
proc auto_execok name {\n\
    global auto_execs env\n\
\n\
    if [info exists auto_execs($name)] {\n\
	return $auto_execs($name)\n\
    }\n\
    set auto_execs($name) 0\n\
    if {[file pathtype $name] != \"relative\"} {\n\
	if {[file executable $name] && ![file isdirectory $name]} {\n\
	    set auto_execs($name) 1\n\
	}\n\
	return $auto_execs($name)\n\
    }\n\
    foreach dir [split $env(PATH) :] {\n\
	if {$dir == \"\"} {\n\
	    set dir .\n\
	}\n\
	set file [file join $dir $name]\n\
	if {[file executable $file] && ![file isdirectory $file]} {\n\
	    set auto_execs($name) 1\n\
	    return 1\n\
	}\n\
    }\n\
    return 0\n\
}\n\
\n\
}",
"proc auto_reset {} {\n\
    global auto_execs auto_index auto_oldpath\n\
    foreach p [info procs] {\n\
	if {[info exists auto_index($p)] && ($p != \"unknown\")\n\
		&& ![string match auto_* $p]} {\n\
	    rename $p {}\n\
	}\n\
    }\n\
    catch {unset auto_execs}\n\
    catch {unset auto_index}\n\
    catch {unset auto_oldpath}\n\
}",
"proc auto_mkindex {dir args} {\n\
    global errorCode errorInfo\n\
    set oldDir [pwd]\n\
    cd $dir\n\
    set dir [pwd]\n\
\n\
    global ::tcl::mkindex-parser::index\n\
    set index \"\"\n\
\n\
    append index \"# Tcl autoload index file, version 2.0 for \\[incr Tcl\\]\\n\"\n\
    append index \"# This file is generated by the \\\"auto_mkindex\\\" command\\n\"\n\
    append index \"# and sourced to set up indexing information for one or\\n\"\n\
    append index \"# more commands.  Typically each line is a command that\\n\"\n\
    append index \"# sets an element in the auto_index array, where the\\n\"\n\
    append index \"# element name is the name of a command and the value is\\n\"\n\
    append index \"# a script that loads the command.\\n\\n\"\n\
    if {$args == \"\"} {\n\
	set args *.tcl\n\
    }\n\
\n\
    foreach file [eval glob $args] {\n\
        if {[catch {tcl::mkindex-parser::mkindex $file} msg] != 0} {\n\
            set code $errorCode\n\
            set info $errorInfo\n\
            cd $oldDir\n\
            error $msg $info $code\n\
        }\n\
    }\n\
\n\
    set fid [open tclIndex w]\n\
    puts $fid $index nonewline\n\
    close $fid\n\
    cd $oldDir\n\
}",
"proc pkg_mkIndex {dir args} {\n\
    global errorCode errorInfo\n\
    append index \"# Tcl package index file, version 1.0\\n\"\n\
    append index \"# This file is generated by the \\\"pkg_mkIndex\\\" command\\n\"\n\
    append index \"# and sourced either when an application starts up or\\n\"\n\
    append index \"# by a \\\"package unknown\\\" script.  It invokes the\\n\"\n\
    append index \"# \\\"package ifneeded\\\" command to set up package-related\\n\"\n\
    append index \"# information so that packages will be loaded automatically\\n\"\n\
    append index \"# in response to \\\"package require\\\" commands.  When this\\n\"\n\
    append index \"# script is sourced, the variable \\$dir must contain the\\n\"\n\
    append index \"# full path name of this file's directory.\\n\"\n\
    set oldDir [pwd]\n\
    cd $dir\n\
    foreach file [eval glob $args] {\n\
	# For each file, figure out what commands and packages it provides.\n\
	# To do this, create a child interpreter, load the file into the\n\
	# interpreter, and get a list of the new commands and packages\n\
	# that are defined.  Define an empty \"package unknown\" script so\n\
	# that there are no recursive package inclusions.\n\
\n\
	set c [interp create]\n\
	$c eval [list set file $file]\n\
	if [catch {\n\
	    $c eval {\n\
		proc dummy args {}\n\
		package unknown dummy\n\
		set origCmds [info commands]\n\
		set dir \"\"		;# in case file is pkgIndex.tcl\n\
		set pkgs \"\"\n\
\n\
		# The \"file join .\" command below is necessary.  Without it,\n\
		# if the file name has no \\'s and we're on UNIX, the\n\
		# LD_LIBRARY_PATH search mechanism will be invoked, which\n\
		# could cause the wrong file to be used.\n\
\n\
		if [catch {load [file join . $file]}] {\n\
		    if {![catch {source $file}]} {\n\
			set type source\n\
		    }\n\
		} else {\n\
		    set type load\n\
		}\n\
		foreach i [info commands] {\n\
		    set cmds($i) 1\n\
		}\n\
		foreach i $origCmds {\n\
		    catch {unset cmds($i)}\n\
		}\n\
		foreach i [package names] {\n\
		    if {([string compare [package provide $i] \"\"] != 0)\n\
			    && ([string compare $i Tcl] != 0)} {\n\
			lappend pkgs [list $i [package provide $i]]\n\
		    }\n\
		}\n\
	    }\n\
	} msg] {\n\
	    interp delete $c\n\
	    error $msg $errorInfo $errorCode\n\
	}\n\
	foreach pkg [$c eval set pkgs] {\n\
	    lappend files($pkg) [list $file [$c eval set type] \\\n\
		    [lsort [$c eval array names cmds]]]\n\
	}\n\
	interp delete $c\n\
    }\n\
    foreach pkg [lsort [array names files]] {\n\
	append index \"\\npackage ifneeded $pkg\\\n\
		\\\"tclPkgSetup \\$dir [lrange $pkg 0 0] [lrange $pkg 1 1]\\\n\
		[list $files($pkg)]\\\"\"\n\
    }\n\
    set f [open pkgIndex.tcl w]\n\
    puts $f $index\n\
    close $f\n\
    cd $oldDir\n\
}",
"proc tclPkgSetup {dir pkg version files} {\n\
    global auto_index\n\
\n\
    package provide $pkg $version\n\
    foreach fileInfo $files {\n\
	set f [lindex $fileInfo 0]\n\
	if {![regexp ^/ $f]} {\n\
	    set f [file join $dir $f]\n\
	}\n\
	set type [lindex $fileInfo 1]\n\
	foreach cmd [lindex $fileInfo 2] {\n\
	    if {$type == \"load\"} {\n\
		set auto_index($cmd) [list load $f $pkg]\n\
	    } else {\n\
		set auto_index($cmd) [list source $f]\n\
	    } \n\
	}\n\
    }\n\
}",
"proc tclPkgUnknown {name version {exact {}}} {\n\
    global auto_path\n\
\n\
    if ![info exists auto_path] {\n\
	return\n\
    }\n\
    for {set i [expr [llength $auto_path] - 1]} {$i >= 0} {incr i -1} {\n\
	set dir [lindex $auto_path $i]\n\
	set file [file join $dir pkgIndex.tcl]\n\
	if [file readable $file] {\n\
	    source $file\n\
	}\n\
    }\n\
}",
"namespace ::tcl::mkindex-parser {\n\
    ::public variable index \"\"          ;# maintains index as it is built\n\
    ::protected variable scriptFile \"\"  ;# name of file being processed\n\
    ::protected variable scopeStack \"\"  ;# stack of namespace scopes\n\
\n\
    # --------------------------------------------------------------------\n\
    # USAGE:  mkindex <fileName>\n\
    #\n\
    # Scans Tcl code from the specified <fileName> and adds entries\n\
    # into the global \"index\" variable for elements that are recognized\n\
    # by the autoloader.\n\
    # --------------------------------------------------------------------\n\
    ::public ::proc mkindex {file} {\n\
        global scriptFile\n\
        set scriptFile $file\n\
\n\
        set fid [open $file]\n\
        set contents [read $fid]\n\
        close $fid\n\
\n\
        #\n\
        # There is one problem with sourcing files into the isolated\n\
        # namespace:  references like \"$x\" will fail since code is not\n\
        # really being executed and variables do not really exist.\n\
        # Be careful to escape all naked \"$\" before evaluating.\n\
        #\n\
        regsub -all {([^\\$])\\$([^\\$])} $contents {\\1\\\\$\\2} contents\n\
        ::namespace ::tcl::mkindex-parser::isolated $contents\n\
    }\n\
\n\
    #\n\
    # Set up an isolated namespace to filter incoming commands.\n\
    # Put the \"enforce_cmd\" proc in the parent namespace, so commands\n\
    # within it work with some sanity.\n\
    #\n\
    ::proc enforce_cmd {name} {\n\
        global commands\n\
        if {[info exists commands($name)]} {\n\
            return $commands($name)\n\
        }\n\
        return \"mkindex_ignore\"\n\
    }\n\
    ::namespace isolated -local -enforced yes\n\
\n\
    #\n\
    # Set up a command registry.  All commands that require an\n\
    # tclIndex entry, and all possible namespace paths for these\n\
    # commands, should be registered in this array.\n\
    #\n\
    # The \"source\" command should work as usual, so that files\n\
    # can be read into the namespace.\n\
    #\n\
    protected variable commands\n\
\n\
    set commands(source) ::source\n\
    set commands(::source) ::source\n\
\n\
    #\n\
    # Most commands get mapped to \"mkindex_ignore\" and are ignored.\n\
    #\n\
    ::proc mkindex_ignore {args} {}\n\
\n\
    #\n\
    # HANDLE:  namespace name ... {commands...}\n\
    #\n\
    ::proc namespace {name args} {\n\
        global scopeStack\n\
        set scopeStack [linsert $scopeStack 0 $name]\n\
\n\
        set cmds [lindex $args end]\n\
        ::namespace isolated $cmds\n\
\n\
        set scopeStack [lrange $scopeStack 1 end]\n\
    }\n\
    set commands(namespace) namespace\n\
    set commands(::namespace) namespace\n\
\n\
    #\n\
    # USAGE:  mkindex_path <name>\n\
    #\n\
    # Returns the complete namespace path for the specified <name>.\n\
    # If <name> starts with \"::\", then it is returned directly.\n\
    # Otherwise, elements from the current namespace stack are added\n\
    # until the complete path starts with \"::\", or until all elements\n\
    # have been added.\n\
    #\n\
    ::protected ::proc mkindex_path {name} {\n\
        global scopeStack\n\
        if {[string match ::* $name]} {\n\
            return $name\n\
        }\n\
        foreach ns $scopeStack {\n\
            set name \"$ns::$name\"\n\
            if {[string match ::* $name]} {\n\
                return $name\n\
            }\n\
        }\n\
        return \"::$name\"\n\
    }\n\
\n\
    #\n\
    # HANDLE:  ensemble name body\n\
    #\n\
    ::proc ensemble {name body} {\n\
        global index scriptFile\n\
        set name [mkindex_path $name]\n\
        append index \"set [list auto_index($name)]\"\n\
        append index \" \\\"source \\$dir/$scriptFile\\\"\\n\"\n\
    }\n\
    set commands(ensemble) ensemble\n\
    set commands(::ensemble) ensemble\n\
\n\
    #\n\
    # HANDLE:  public ...\n\
    #          protected ...\n\
    #          private ...\n\
    #\n\
    ::proc plevel {args} {\n\
        if {[llength $args] == 1} {\n\
            ::namespace isolated [lindex $args 0]\n\
        } else {\n\
            ::namespace isolated $args\n\
        }\n\
    }\n\
    set commands(public) plevel\n\
    set commands(::public) plevel\n\
    set commands(protected) plevel\n\
    set commands(::protected) plevel\n\
    set commands(private) plevel\n\
    set commands(::private) plevel\n\
\n\
    #\n\
    # HANDLE:  proc name arglist body\n\
    #\n\
    ::proc proc {name arglist body} {\n\
        global index scriptFile\n\
        set name [mkindex_path $name]\n\
        append index \"set [list auto_index($name)]\"\n\
        append index \" \\\"source \\$dir/$scriptFile\\\"\\n\"\n\
    }\n\
    set commands(proc) proc\n\
    set commands(::proc) proc\n\
}",
