'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id$
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH public n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
public \- create commands/variables with "public" access
.SH SYNOPSIS
\fBpublic \fIcommand \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
Sets the protection level for new commands/variables to "public"
and then evaluates the remaining arguments.  Note that the default
protection level for commands/variables is "public".  Other protection
levels are "protected" and "private".
.PP
The \fIcommand\fR argument may be a command name like \fBproc\fR
or \fBvariable\fR, or a script full of command/variable declarations.
Any command that creates another command or variable can be used
in conjunction with the \fBpublic\fR command.  For example, if widget
commands are executed via "public", the widget access commands will
be public.
.PP
Public commands/variables are accessible from any namespace.

.SH EXAMPLE
.CS
namespace foo {
    public {
        variable x 0
        variable y 1
    }
    public proc check {} {
        global x y
        return "$x $y"
    }
}
foo::check
.CE

.SH KEYWORDS
namespace, private, protected, public, variable, proc
