'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) shell.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS shell iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
shell \- Create and manipulate a shell widget
.SH SYNOPSIS
\fBshell\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- shell
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBmodality\fR
Class:	\fBModality\fR
Command-Line Switch:	\fB-modality\fR
.fi
.IP
Allows the shell to grab control of the screen in one of three different ways:
\fBapplication\fR, \fBsystem\fR, or \fBnone\fR.
Application modal prevents any other toplevel windows within the application
which are direct children of '.' from gaining focus.  System modal locks 
the screen and prevents all windows from gaining focus regardless of 
application.  A modality of none performs no grabs at all.  The default 
is none.
.LP
.nf
Name:	\fBpadX\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB-padx\fR
.fi
.IP
Specifies a padding distance for the childsite in the X-direction in
any of the forms acceptable to \fBTk_GetPixels\fR.  The default is 10.
.LP
.nf
Name:	\fBpadY\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB-pady\fR
.fi
.IP
Specifies a padding distance for the childsite in the Y-direction in
any of the forms acceptable to \fBTk_GetPixels\fR.  The default is 10.
.LP
.nf
Name:	\fBtitle\fR
Class:	\fBTitle\fR
Command-Line Switch:	\fB-title\fR
.fi
.IP
String to be displayed in the title window decoration.  
.LP
.BE

.SH DESCRIPTION
.PP
The \fBshell\fR command creates a shell which is a top 
level widget which supports modal operation.

.SH "METHODS"
.PP
The \fBshell\fR command create a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for shell widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBactivate\fR
Display the shell and wait based on the modality.  For application
and system modal activations, perform a grab operation, and wait
for the result.  The result may be returned via an argument to the
\fBdeactivate\fR method.
.TP
\fIpathName \fBcenter\fR \fI?widget?\fR
Centers the shell with respect to another widget.  The widget argument
is optional.  If provided, it should be the path of another widget with
to center upon.  If absent, then the shell will be centered on the screen
as a whole.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBshell\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the pathname of the child site widget.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBshell\fR
command.
.TP
\fIpathName \fBdeactivate\fR ?\fIarg\fR?
Deactivate the display of the shell.  The method takes an optional
argument to be passed to the \fBactivate\fR method which returns the value.
The optional argument is only effective for application and system 
modal dialogs.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBshellchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The shellchildsite component is the user child site for the shell.  See 
the "frame" widget manual entry for details on the shellchildsite 
component item.
.fi

.SH EXAMPLE
.DS
 shell .sh -modality application -padx 20 -pady 20 -title Shell

 pack [label [.sh childsite].l -text SHELL]

 .sh center
 .sh activate
.DE
.SH AUTHOR
Mark L. Ulferts
.DE
Kris Raney
.LP
.SH KEYWORDS
shell, widget
