'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) fileselectionbox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS fileselectionbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
fileselectionbox \- Create and manipulate a file selection box widget
.SH SYNOPSIS
\fBfileselectionbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Fileselectionbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR
\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR	\fBselectBackground\fR
\fBselectBorderWidth\fR	\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	\fBlabelMargin\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBhscrollMode\fR	\fBsbWidth\fR	\fBscrollMargin\fR	\fBtextBackground\fR
\fBtextFont\fR	\fBvscrollMode\fR
.fi
.LP
See the "scrolledlistbox" widget manual entry for details on the above
associated options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the selection box: \fBn\fR, 
\fBs\fR, \fBe\fR, \fBw\fR, or \fBcenter\fR.  The default is center.
.LP
.nf
Name:	\fBdblDirsCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-dbldirscommand\fR
.fi
.IP
Specifies a Tcl command procedure which is called when an directory list item
is double clicked.  Typically this occurs when mouse button 1 is double 
clicked over a directory name.
.LP
.nf
Name:	\fBdblFilesCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-dblfilescommand\fR
.fi
.IP
Specifies a Tcl command procedure which is called when an file list item is
double clicked.  Typically this occurs when mouse button 1 is double 
clicked over a file name.
.LP
.nf
Name:	\fBdirectory\fR
Class:	\fBDirectory\fR
Command-Line Switch:	\fB-directory\fR
.fi
.IP
Specifies the initial default directory.  The default is the present 
working directory.
.LP
.nf
Name:	\fBdirSearchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-dirsearchcommand\fR
.fi
.IP
Specifies a Tcl command to be executed to perform a directory search.
The command will receive the current working directory and filter
mask as arguments.  The command should return a list of files which
will be placed into the directory list.
.LP
.nf
Name:	\fBdirsLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-dirslabel\fR
.fi
.IP
Specifies the text of the label for the directory list.  The default is
"Directories".
.LP
.nf
Name:	\fBdirsLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-dirslabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the directory
list: \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, or 
\fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBdirsOn\fR
Class:	\fBDirsOn\fR
Command-Line Switch:	\fB-dirson\fR
.fi
.IP
Specifies whether or not to display the directory list.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBfileSearchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-filesearchcommand\fR
.fi
.IP
Specifies a Tcl command to be executed to perform a file search.
The command will receive the current working directory and filter
mask as arguments.  The command should return a list of files which
will be placed into the file list.
.LP
.nf
Name:	\fBfilesLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-fileslabel\fR
.fi
.IP
Specifies the text of the label for the files list.  The default is "Files".
.LP
.nf
Name:	\fBfilesLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-fileslabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the files
list: : \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, or 
\fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBfilesOn\fR
Class:	\fBFilesOn\fR
Command-Line Switch:	\fB-fileson\fR
.fi
.IP
Specifies whether or not to display the files list.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBfileType\fR
Class:	\fBFileType\fR
Command-Line Switch:	\fB-filetype\fR
.fi
.IP
Specify the type of files which may appear in the file list: \fBregular\fR,
\fBdirectory\fR, or \fBany\fR.  The default is regular.
.LP
.nf
Name:	\fBfilterCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-filtercommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon hitting the Return key
in the filter entry widget.  
.LP
.nf
Name:	\fBfilterFocusCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-filterfocuscommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon reception of focus by the filter.
.LP
.nf
Name:	\fBfilterLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-filterlabel\fR
.fi
.IP
Specifies the text of the label for the filter entry field.  The default is
"Filter".
.LP
.nf
Name:	\fBfilterLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-filterlabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the filter: \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, or 
\fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBfilterOn\fR
Class:	\fBFilterOn\fR
Command-Line Switch:	\fB-filteron\fR
.fi
.IP
Specifies whether or not to display the filter entry.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 360 pixels.
.LP
.nf
Name:	\fBhorizmargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-horizmargin\fR
.fi
.IP
Specifies distance between the lists and filter/selection entries.  The
value may be given in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 7.
.LP
.nf
Name:	\fBinvalid\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-invalid\fR
.fi
.IP
Command to be executed should the filter contents be proven 
invalid.  The default is {bell}.
.LP
.nf
Name:	\fBmask\fR
Class:	\fBMask\fR
Command-Line Switch:	\fB-mask\fR
.fi
.IP
Specifies the initial file mask string.  The default is "*".
.LP
.nf
Name:	\fBnoMatchString\fR
Class:	\fBNoMatchString\fR
Command-Line Switch:	\fB-nomatchstring\fR
.fi
.IP
Specifies the string to be displayed in the files list should no files
match the mask.  The default is "[   ]".
.LP
.nf
Name:	\fBselectDirCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectdirommand\fR
.fi
.IP
Specifies a Tcl command to be executed following selection of a 
directory in the directory list.
.LP
.nf
Name:	\fBselectFileCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectfileommand\fR
.fi
.IP
Specifies a Tcl command to be executed following selection of a 
file in the files list.
.LP
.nf
Name:	\fBselectionCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectioncommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon hitting the Return key
in the selection entry widget.  
.LP
.nf
Name:	\fBselectionFocusCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectionfocuscommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon reception of focus by the 
selection entry.
.LP
.nf
Name:	\fBselectionImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-selectionimage\fR
.fi
.IP
Specifies a image to be used as the selection entry label. The image may 
be any of the values created by the \fBimage create\fR command.
.LP
.nf
Name:	\fBselectionLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-selectionlabel\fR
.fi
.IP
Specifies the text of the label for the selection entry field.  The default
is "Selection".
.LP
.nf
Name:	\fBselectionLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-selectionlabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the selection: \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, or 
\fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBselectionOn\fR
Class:	\fBSelectionOn\fR
Command-Line Switch:	\fB-selectionon\fR
.fi
.IP
Specifies whether or not to display the selection entry.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBvertmargin\fR
Class:	\fBtMargin\fR
Command-Line Switch:	\fB-vertmargin\fR
.fi
.IP
Specifies distance between the directory and file lists.  The
value may be given in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 7.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 470 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBfileselectionbox\fR command creates a file selection box similar 
to the OSF/Motif standard Xmfileselectionbox composite widget.  The 
fileselectionbox is composed of directory and file scrolled lists as 
well as filter and selection entry fields.  Bindings are in place such that
selection of a directory list item loads the filter entry field and
selection of a file list item loads the selection entry field.  Options
exist to control the appearance and actions of the widget.

.SH "METHODS"
.PP
The \fBfileselectionbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for fileselectionbox widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBfileselectionbox\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the child site widget path name.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBfileselectionbox\fR
command.
.TP
\fIpathName \fBfilter\fR
Update the current contents of the file selection box based on the current
filter entry field value.
.TP
\fIpathName \fBget\fR
Returns the current value of the selection entry widget.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBchildsite\fR
Class:	\fBFrame\fR
.fi
.IP
The childsite component is the user child site for the file selection box.
See the "frame" widget manual entry for details on the childsite component
item.
.LP
.nf
Name:	\fBdirs\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The dirs component is the directory list box for the file selection box.
See the "scrolledlistbox" widget manual entry for details on the dirs 
component item.
.LP
.nf
Name:	\fBfiles\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The files component is the file list box for the file selection box.
See the "scrolledlistbox" widget manual entry for details on the files
component item.
.LP
.nf
Name:	\fBfilter\fR
Class:	\fBEntryfield\fR
.fi
.IP
The filter component is the entry field for user input of the filter value.
See the "entryfield" widget manual entry for details on the filter 
component item.
.LP
.nf
Name:	\fBselection\fR
Class:	\fBEntryfield\fR
.fi
.IP
The selection component is the entry field for user input of the currently
selected file value.  See the "entryfield" widget manual entry for details 
on the selection component item.
.fi

.SH EXAMPLE
.DS
option add *textBackground GhostWhite

fileselectionbox .fsb
pack .fsb -padx 10 -pady 10 -fill both -expand yes 
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
fileselectionbox, widget
