#!/bin/sh
# The next line restarts using tclsh7.5 \
exec tclsh7.5 $0 ${1+"$@"}

#
# pkgInstall.tcl
#
# script to install a pkgIndex.tcl file
# into <exec-prefix>/lib
#
# Written by:	Jan Nijtmans
#		NICI (Nijmegen Institute of Cognition and Information)
#		email: nijtmans@nici.kun.nl
#		url:   http://www.nici.kun.nl/~nijtmans/

if {[llength $argv] != 1} {
    puts stderr "usage: pkgInstall.tcl prefix"
    exit 1
}

set dir [lindex $argv 0]
set pkgIndex ""

set f [open pkgIndex.tcl r]
set line ""
while {![regexp "^package ifneeded" $line] && ![eof $f]} {
    set line [gets $f]
    append pkgIndex "${line}\n"
}
while {![info complete $pkgIndex] && ![eof $f]} {
    set line [gets $f]
    append pkgIndex "${line}\n"
}
close $f

regexp {package ifneeded ([A-Z][a-z_]+) ([0-9\.]+) } $pkgIndex \
		trash Pkgname version

if {![catch {set f [open "$dir/pkgIndex.tcl" r]}]} {
    set line {}
    while {![regexp "^package ifneeded" $line] && ![eof $f]} {
	set line [gets $f]
    }
    while {![eof $f]} {
	set chunk "${line}\n"
	while {![info complete $chunk] && ![eof $f]} {
	    set line [gets $f]
	    append chunk "${line}\n"
	}
	if {![regexp "^package ifneeded $Pkgname $version " $chunk] &&
		[regexp "^package ifneeded" $chunk]} {
	    append pkgIndex $chunk
	}
	set line [gets $f]
    }
    close $f
}

set f [open "$dir/pkgIndex.tcl" w]
puts -nonewline $f $pkgIndex
flush $f
close $f
