# RCS Id:
#  $Id: complexWidgets.tcl,v 1.2.2.3 1995/06/24 18:57:46 ndanger Exp $

###     complexWidgets.tcl : Make more complicated widgets based on
###       basicWidgets.tcl
###     Copyright (C) 1995 Norman Danner
### 
###     This program is free software; you can redistribute it and/or modify
###     it under the terms of the GNU General Public License as published by
###     the Free Software Foundation; either version 2 of the License, or
###     (at your option) any later version.
### 
###     This program is distributed in the hope that it will be useful,
###     but WITHOUT ANY WARRANTY; without even the implied warranty of
###     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
###     GNU General Public License for more details.
### 
###     You should have received a copy of the GNU General Public License
###     along with this program; if not, write to the Free Software
###     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

set CW(modalDlg,font) "-*-helvetica-bold-r-*-18-*"
set CW(modalDlg,aspect) 700
set CW(modalDlg,retval) -1
set CW(fileSelect,dir) ""
set CW(fileSelect,dirlist) {}
set CW(fileSelect,file) ""
set CW(fileSelect,window) ""
set CW(fileSelect,showhidden) 0
set CW(fileSelect,filter) "*"
set CW(fileSelect,transient) 1
set CW(fileSelect,modal) 0
set CW(comboWin,hpackdefs) "-fill both -expand yes"


# This proc can just be called to force auto-loading, so that the CW
# array is set.
proc CWinit {} {
  
  global CW
  global tk_version
  
  if {[lindex [split $tk_version "."] 0] == "3"} {
    set CW(tk3) 1
    set CW(tk4) 0
  } else {
    set CW(tk3) 0
    set CW(tk4) 1
  }
  
}

proc CWintTrace {array element op} {

	global CW
	
	if {[string match "fileSelect,file" $element]} {
	    if {[string match "" $CW(fileSelect,file)]} \
	      {$CW(fileSelect,actbutton) configure -state disabled} \
	      {$CW(fileSelect,actbutton) configure -state normal}
	}
	
}



proc ButtonPanel {w def blist args} {

    global BW
    
    frame $w -relief raised -borderwidth 1
    set buttons {}

    for {set b 0} {$b < [llength $blist]} {incr b} {
	set n [UniqueSubwindow $w button]
	button $n -text [lindex $blist $b]
	if {$b == $def} {$n configure -relief groove -bd 5}
	pack $n -side left -padx $BW(buttonPanel,padx) \
	  -fill x -expand yes
	lappend buttons "$n"
    }
    
    if {[llength $args] != 0} {
   	foreach b $buttons {eval $b configure $args}
    }

    return $buttons

}


proc ButtonPanelCmd {w def blist args} {

    global BW
    
    set blabels ""
    set cmds ""
    foreach b $blist {
    	lappend blabels [lindex $b 0]
    	lappend cmds [lindex $b 1]
    }
    set buttons [ButtonPanel $w $def $blabels]
    if {[llength $args] != 0} {
    	foreach b $buttons {eval "$b configure " $args}
    }
    for {set i 0} {$i < [llength $buttons]} {incr i} {
    	if {![string match "" [lindex $cmds $i]]} \
    	  {[lindex $buttons $i] configure -command "[lindex $cmds $i]"} \
    	  {[lindex $buttons $i] configure -state disabled}
    }
    return $buttons
    
}
    

proc ModalDlg {message title def args} {

	global CW
	
	if [winfo exists .modal] {destroy .modal}
	toplevel .modal
	if {![string match "" $title]} {wm title .modal $title}
	wm transient .modal .
	
	message .modal.l -text $message -relief raised \
	  -bd 1 -font $CW(modalDlg,font) -aspect $CW(modalDlg,aspect)
	
	for {set i 0} {$i < [llength $args]} {incr i} {
	    lappend buttons "\{[lindex $args $i]\} \{set CW(modalDlg,retval) $i\}"
	}
	set blist [ButtonPanelCmd .modal.w $def $buttons]

	pack .modal.l -fill x
	pack .modal.w -fill x -pady 5
	bind .modal <Return> "[lindex $blist $def] invoke"
	
	focus .modal
	grab .modal
	
	tkwait variable CW(modalDlg,retval)
	destroy .modal
	return $CW(modalDlg,retval)
	
}


proc ComboWin {w args} {

	global CW
	
	foreach vw $args {
	    set panel [UniqueSubwindow $w frame]
	    frame $panel
	    pack $panel -in $w -side top -fill both
	    set optstart 0
	    for {set i 0} {$i < [llength $vw]} {incr i} {
	    	if {[string first "-" [lindex $vw $i]] == 0} {
	    	    set optstart $i
	    	    break
	    	}
	    }
	    if {$optstart == 0} {
	    	set optstart [llength $vw]
	    	foreach a $CW(comboWin,hpackdefs) {lappend vw $a}
	    }
	    for {set j 0} {$j < $optstart} {incr j} {
	    	set hw [lindex $vw $j]
		pack $hw -in $panel -side left
		for {set i $optstart} {$i < [llength $vw]} {incr i 2} {
		    pack configure $hw [lindex $vw $i] [lindex $vw [expr $i+1]]
		}
		raise $hw $panel
	    }
	}
		
}



proc cwIntDisplayFiles {d_lb f_lb f_mnu} {

	global CW
	global errorCode
	
	$d_lb delete 0 end
	$f_lb delete 0 end

	set d ".."
	if {$CW(fileSelect,showhidden)} {set gpat "\{.*,*\}"} {set gpat "*"}
	foreach f [lsort [glob -nocomplain $CW(fileSelect,dir)/$gpat]] {
	    if {[file isdir $f] && \
	        ![string match "." [file tail $f]] && \
	        ![string match ".." [file tail $f]]} {lappend d [file tail $f]}
	}
	foreach di $d {$d_lb insert end $di}

	if {$CW(fileSelect,showhidden)} \
	  {set gpat "\{.$CW(fileSelect,filter),$CW(fileSelect,filter)\}"} \
	  {set gpat "$CW(fileSelect,filter)"}

	foreach f [lsort [glob -nocomplain $CW(fileSelect,dir)/$gpat]] {
	  if {[file isfile $f]} {$f_lb insert end [file tail $f]}
	}
	
	$f_mnu delete 0 last
	if {[info exists CW(fileSelect,$CW(fileSelect,dir))]} {
	    foreach f $CW(fileSelect,$CW(fileSelect,dir)) {
	    	$f_mnu add command -label $f -command "
	    	  set CW(fileSelect,file) $f
	    	  $CW(fileSelect,actbutton) invoke
	    	"
	    }
	}

}


proc cwIntFileMenus {d_mnu d_lb f_mnu f_lb} {

	global CW
	
	set d $CW(fileSelect,dir)
	
	if {[lsearch $CW(fileSelect,dirlist) $d] == -1} \
	  {lappend CW(fileSelect,dirlist) $d}
	
	if {![info exists CW(fileSelect,$d)]} {
	    set CW(fileSelect,$d) $CW(fileSelect,file)
	} \
	else {
	    if {[lsearch $CW(fileSelect,$d) $CW(fileSelect,file)] == -1} \
	      {lappend CW(fileSelect,$d) $CW(fileSelect,file)}
	}
	

}


proc FileSelect {w dir message act_lbl} {

    	global CW
	global env
	
    	if {$dir == ""} {
    	  if {$CW(fileSelect,dir) == ""} \
    	    {set CW(fileSelect,dir) [pwd]}
    	} \
    	else {set CW(fileSelect,dir) $dir}
    	set CW(fileSelect,cancel) 0
	    
    	set CW(fileSelect,window) $w
	toplevel $w
	if {$CW(fileSelect,transient)} {wm transient $w .}
	if {$CW(fileSelect,modal)} {grab set $w}
	
	label $w.l -relief raised -bd 1 -text "$message"
		  
	ScrollListBox $w.dirs
	ScrollListBox $w.files

	if {$CW(tk3)} {
	  tk_listboxSingleSelect [$w.dirs listbox] [$w.files listbox]
	} else {
  	  [$w.dirs listbox] configure -selectmode browse
  	  [$w.files listbox] configure -selectmode browse
  	}
	
	MButtonEntryH $w.d_entry "Directory:" {-textvar CW(fileSelect,dir) -width 40}
	MButtonEntryH $w.f_entry "File:" {-textvar CW(fileSelect,file) -width 40}
	LabelEntryH $w.filter "Filter:" {-width 40 -textvar CW(fileSelect,filter)}
	
	button $w.home -text "Home" -relief raised -bd 1 -command "
  	  set CW(fileSelect,dir) $env(HOME)
  	  set CW(fileSelect,file) \"\"
  	  cwIntDisplayFiles [$w.dirs listbox] [$w.files listbox] \
    	   [$w.f_entry menu]
  	"

	checkbutton $w.allfiles -text "All Files" -relief raised -bd 1 \
	  -command "
	  set CW(fileSelect,showhidden) \$allfiles
	  cwIntDisplayFiles [$w.dirs listbox] [$w.files listbox] \
	    [$w.f_entry menu]
	"
	foreach d $CW(fileSelect,dirlist) {
	    [$w.d_entry menu] add command -label $d -command "
	    	set CW(fileSelect,dir) $d
	    	set CW(fileSelect,file) \"\"
	    	cwIntDisplayFiles [$w.dirs listbox] [$w.files listbox] \
	    	  [$w.f_entry menu]
	    "
	}
	
	set CW(fileSelect,actbutton) \
	  [lindex [ButtonPanelCmd $w.b 0 {
	    {{} {
	      cwIntFileMenus [$CW(fileSelect,window).d_entry menu] \
	        [$CW(fileSelect,window).dirs listbox] \
	        [$CW(fileSelect,window).f_entry menu] \
	        [$CW(fileSelect,window).files listbox]
	      set CW(fileSelect,cancel) 0
	    }} 
	    {Cancel {set CW(fileSelect,cancel) 1}}
	  }] 0]
	$CW(fileSelect,actbutton) configure -text "$act_lbl"
	
	bind [$w.d_entry entry] <Return> "
	    set CW(temp) \[[$w.d_entry entry] get\]
	    if {\[string first \"/\" \$CW(temp)\] != 0} return
	    set CW(fileSelect,dir) \"\$CW(temp)\"
	    set CW(fileSelect,file) \"\"
	    cwIntDisplayFiles [$w.dirs listbox] [$w.files listbox] \
	      [$w.f_entry menu]
	"
	
	bind [$w.filter entry] <Return> "cwIntDisplayFiles [$w.dirs listbox] \
	  [$w.files listbox] [$w.f_entry menu]"
	
	bind [$w.dirs listbox] <Double-Button-1> "
	    set CW(temp) \[[$w.dirs listbox] get \[[$w.dirs listbox] curselection\]\]
	    if {\"..\" == \$CW(temp)} \
	      {set CW(fileSelect,dir) \[file dirname \$CW(fileSelect,dir)\]} \
	      {append CW(fileSelect,dir) \"/\$CW(temp)\"}
	    set CW(fileSelect,file) \"\"
	    cwIntDisplayFiles [$w.dirs listbox] [$w.files listbox] \
	      [$w.f_entry menu]
	"
	
# 	bind [$w.files listbox] <1> "+
# 	    set CW(fileSelect,file) \$BW(scrollListBox,sel)
# 	"
	
	if {$CW(tk3)} {
  	  bind [$w.files listbox] <1> {
    	    %W select from [%W nearest %y]
  	    set CW(fileSelect,file) [%W get [%W curselection]]
	  }
	} else {
	  bindtags [$w.files listbox] [list Listbox [$w.files listbox] . all]
	  bind [$w.files listbox] <1> {
	    set CW(fileSelect,file) [%W get [%W curselection]]
	  }
	}

	bind [$w.files listbox] <Double-1> "$CW(fileSelect,actbutton) invoke"
	bind [$w.f_entry entry] <Return> "$CW(fileSelect,actbutton) invoke"
	
    	cwIntDisplayFiles [$w.dirs listbox] \
    	  [$w.files listbox] [$w.f_entry menu]

	ComboWin $w $w.l "$w.dirs $w.files" $w.d_entry $w.f_entry \
	  "$w.filter $w.home $w.allfiles" $w.b
	
	trace variable CW(fileSelect,file) w CWintTrace
	set CW(fileSelect,file) ""
	
	tkwait variable CW(fileSelect,cancel)
	
	if {$CW(fileSelect,modal)} {grab release $w}
	trace vdelete CW(fileSelect,file) w CWintTrace

	destroy $w
	if {$CW(fileSelect,cancel)} \
	  {return ""} \
	  {return $CW(fileSelect,dir)/$CW(fileSelect,file)}
	
}














