'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id$
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH private n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
private \- create commands/variables with "private" access
.SH SYNOPSIS
\fBprivate \fIcommand \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
Sets the protection level for new commands/variables to "private"
and then evaluates the remaining arguments.  Note that the default
protection level for commands/variables is "public".  Commands and
variables can also be "protected".
.PP
The \fIcommand\fR argument may be a command name like \fBproc\fR
or \fBvariable\fR, or a script full of command/variable declarations.
Any command that creates another command or variable can be used
in conjunction with the \fBprivate\fR command.  For example, if widget
commands are executed via "private", the widget access commands will
be private.
.PP
Private commands/variables are only accessible in the namespace where
they are defined.

.SH EXAMPLE
.CS
namespace foo {
    private {
        variable x 0
        variable y 1
    }
    private proc check {} {
        global x y
        return "$x $y"
    }
}

namespace foo {  ;# access allowed
    check
}
foo::check       ;# access denied
.CE

.SH KEYWORDS
import, namespace, private, protected, public, variable, proc
