'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id$
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH ensemble n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ensemble \- create or modify a composite command
.SH SYNOPSIS
\fBensemble \fIname\fR {
.br
    \fBoption \fIoptName args body\fR
.br
    \fBoption \fIoptName args body\fR
.br
    \fI...\fR
    \fBensemble \fIoptName\fR {
.br
        \fBoption \fIsubOptName args body\fR
.br
        \fBoption \fIsubOptName args body\fR
.br
    }
.br
}
.BE

.SH DESCRIPTION
.PP
The \fBensemble\fR command is used to create or modify a composite
command.  Many Tcl commands, like the usual \fBinfo\fR command,
are composite commands with option parts.  These commands are
usually implemented by tediously checking the option strings
and handling the appropriate case.  New options cannot be added
without modifying the underlying C code.
.PP
With the ensemble facility, composite commands can be created
and extended in an automatic way.  The \fBensemble\fR command
finds an existing ensemble \fIname\fR and adds options to it,
or creates an ensemble \fIname\fR and installs a Tcl command
called \fIname\fR to access it.  Within the ensemble definition,
a series of \fBoption\fR statements define the allowed options.
The syntax of the \fBoption\fR statement is identical to the
usual Tcl \fBproc\fR command.  Ensemble definitions can also
be nested, so options themselves can have sub-option parts.
.PP
The ensemble facility not only automates the construction of
composite commands, it automates the error handling as well.
For example, the usual Tcl \fBinfo\fR command is now implemented
as an ensemble.  When the \fBinfo\fR command is invoked without
any arguments, the following error message is generated:
.CS
wrong # args: should be one of...
  info args procname
  info body procname
  info cmdcount
  info commands ?pattern?
  info complete command
  info context
  info default procname arg varname
  info exists varName
  info globals ?pattern?
  info level ?number?
  info library
  info locals ?pattern?
  info namespace option ?arg arg ...?
  info patchlevel
  info procs ?pattern?
  info protection ?-command? ?-variable? name
  info script
  info tclversion
  info vars ?pattern?
  info which ?-command? ?-variable? ?-namespace? name\fR
.CE
When new options are integrated into the ensemble, their usage
information will be included in the error message as well.
.PP
When the ensemble \fIname\fR command is invoked, the first
argument on the command line is matched against the list of
available options.  The ensemble facility also supports option
abbreviations, so that "\fCinfo comm\fR" works as well as
"\fCinfo commands\fR".  The minimum number of characters for
unique abbreviations is automatically determined as new options
are added to the ensemble.
.PP
If an option is ambiguous or not recognized at all, the ensemble
facility looks for an option named "\fC@error\fR", and if it
is found, passes control to it.  This option will receive all
of the arguments on the command line starting with the offending
option name.  It can find another way of resolving the command,
or generate its own error message.  If the "\fC@error\fR"
option is not found, the ensemble facility automatically generates
an error message with the usage information for all known options.

.SH EXAMPLE
The \fBdelete\fR command is an ensemble supporting various
"delete" operations.  By default, only namespaces can be deleted.
When the [incr Tcl] extension is added, "object" and "class"
options are added to the \fBdelete\fR command.  We can use
this same command to provide a uniform way of deleting all
kinds of system resources.  For example, we can add an option
to delete Tk widgets:
.CS
ensemble delete {
    option widget {name args} {
        eval destroy $name $args
    }
}
button .b -text "Testing"
delete widget .b
.CE

.SH KEYWORDS
proc, option, info, delete
