'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id$
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH @scope n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
@scope \- prefix for scoped values
.SH SYNOPSIS
\fB@scope \fInamespace\fR \fIvarName\fR
.br
\fB@scope \fInamespace\fR \fIcommand\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
Any command or variable name starting with \fB@scope\fR is treated
as a scoped value.  The associated \fInamespace\fR is activated
before the command is executed or the variable is accessed.
.PP
With namespaces, commands and variables are no longer simple strings;
they are names with an associated context.  Scoped values capture the
namespace context of a command/variable in a form that can be passed
around at the Tcl language level.  They are usually created by wrapping
code fragments with the \fBcode\fR command, and variable names with
the \fBscope\fR command.  They are rarely generated by hand.
.PP
Any variable name starting with \fB@scope\fR is automatically
recognized as a global variable in the specified \fInamespace\fR.
Access is allowed from any namespace, even if the variable is
protected or private.  Scoped variables can be used anywhere that
an ordinary variable name is recognized.  For example, the following
statements are allowed:
.CS
namespace foo {
    variable mode "1"
}
set {@scope ::foo mode} 3
puts "value = ${@scope ::foo mode}"
.CE
.PP
Any command name starting with \fB@scope\fR is automatically
executed in the specified \fInamespace\fR.  If additional \fIarg\fR
arguments are included, the command string is built by appending
the extra \fIarg\fR as list elements to the end of the \fIcommand\fR
string.  This preserves the integrity of the arguments, while
keeping the code fragment \fIcommand\fR as a flat string.  For
example:
.CS
@scope ::foo {.b configure} -text "Hello World!"
.CE
is equivalent to:
.CS
namespace ::foo {.b configure -text {Hello World!}}
.CE
Since scoped commands are executed in their \fInamespace\fR context,
they provide a way to access protected and private commands from
any other namespace.  In effect, the \fB@scope\fR command is a lot
like the \fBnamespace\fR command, but it allows extra arguments to
be appended to the command.

.SH KEYWORDS
@scope, code, scope, namespace, private, protected, public
