'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) dialog.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS dialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
dialog \- Create and manipulate a dialog widget
.SH SYNOPSIS
\fBdialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- Shell <- Dialogshell <- Dialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR 	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR	
.fi
.LP
See the "dialogshell" manual entry for details on the above inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBmodality\fR	\fBtitle\fR 
.fi
.LP
See the "shell" manual entry for details on the above inherited options.
.BE

.SH DESCRIPTION
.PP
The \fBdialog\fR command creates a dialog box providing standard
buttons and a child site for use in derived classes.  The buttons
include ok, apply, cancel, and help.  Methods and Options exist to 
configure the buttons and their containing box.

.SH "METHODS"
.PP
The \fBdialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for dialog widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBindex\fR	\fBinsert\fR	\fBinvoke\fR	\fBshow\fR
.fi
.LP
See the "buttonbox" manual entry for details on the above inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBchildsite\fR	
.fi
.LP
See the "dialogshell" manual entry for details on the above inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBdialog\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBdialog\fR
command.

.SH EXAMPLE
.DS
 dialog .d -modality global
 .d buttonconfigure OK -command {puts OK; .d deactivate 1}
 .d buttonconfigure Apply -command {puts Apply}
 .d buttonconfigure Cancel -command {puts Cancel; .d deactivate 0}
 .d buttonconfigure Help -command {puts Help}
 
 listbox [.d childsite].lb -relief sunken
 pack [.d childsite].lb -expand yes -fill both

 if {[.d activate]} {
     puts "Exit via OK button"
 } else {
     puts "Exit via Cancel button"
 }
.DE
.SH AUTHOR
Mark L. Ulferts
.DE
Bret A. Schuhmacher
.SH KEYWORDS
dialog, dialogshell, shell, widget
