'\"
'\" canvasprintbox (c) 1995 Tako Schotanus
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'/" 
.so man.macros
.HS canvasprintbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
canvasprintbox \- Create and manipulate a canvas print box widget
.SH SYNOPSIS
\fBcanvasprintbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Canvasprintbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBforeground\fR	\fBhighlightBackground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
\fBinsertBackground\fR	\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR
\fBselectBackground\fR	\fBselectBorderWidth\fR	\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.IP
.LP
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBfilename\fR
Class:	\fBFileName\fR
Command-Line Switch:	\fB-filename\fR
.fi
.IP
The file to write the postscript output to (Only when output
is set to "file"). If posterizing is turned on and \fBhpagecnt\fR
and/or \fBvpagecnt\fR is more than 1, x.y is appended to the filename
where x is the horizontal page number and y the vertical page number.
.LP
.nf
Name:	\fBhpagecnt\fR
Class:	\fBPageCnt\fR
Command-Line Switch:	\fB-hpagecnt\fR
.fi
.IP
Is used in combination with \fBposterize\fR to determine over
how many pages the output should be distributed. This
attribute specifies how many pages should be used horizontaly.
Any change to this attribute will automatically update the "stamp".
Defaults to 1.
.LP
.nf
Name:	\fBorient\fR
Class:	\fBOrient\fR
Command-Line Switch:	\fB-orient\fR
.fi
.IP
Determines the orientation of the output to the printer (or file).
It can take the value "portrait" or "landscape" (default). Changes
to this attribute will be reflected immediately in the "stamp".
Defaults to "landscape" but will be changed automaticaly to the value
deemed appropiate for the current canvas. Setting this attribute
when the canvasprintbox is first constructed (instead of using the
"configure" method) will turn off the auto adjustment of this attribute.
.LP
.nf
Name:	\fBoutput\fR
Class:	\fBOutput\fR
Command-Line Switch:	\fB-output\fR
.fi
.IP
Specifies where the postscript output should go: to the printer
or to a file. Can take on the values "printer" or "file".
The corresponding entry-widget will reflect the contents of
either the \fBprintcmd\fR attribute or the \fBfilename\fR attribute.
Defaults to "printer".
.LP
.nf
Name:	\fBpageSize\fR
Class:	\fBPageSize\fR
Command-Line Switch:	\fB-pagesize\fR
.fi
.IP
The pagesize the printer supports. Changes to this attribute
will be reflected immediately in the "stamp".
Defaults to "a4".
.LP
.nf
Name:	\fBposterize\fR
Class:	\fBPosterize\fR
Command-Line Switch:	\fB-posterize\fR
.fi
.IP
Indicates if posterizing is turned on or not. Posterizing
the output means that it is possible to distribute the
output over more than one page. This way it is possible to
print a canvas/region which is larger than the specified
pagesize without stretching. If used in combination with
stretching it can be used to "blow up" the contents of a
canvas to as large as size as you want (See attributes:
hpagecnt and vpagecnt). Any change to this attribute will
automatically update the "stamp".
Defaults to 0.
.LP
.nf
Name:	\fBprintCmd\fR
Class:	\fBPrintCmd\fR
Command-Line Switch:	\fB-printcmd\fR
.fi
.IP
The command to execute when printing the postscript output.
The command will get the postscript directed to its standard
input (Only when output is set to "printer").
Defaults to "lpr".
.LP
.nf
Name:	\fBprintRegion\fR
Class:	\fBPrintRegion\fR
Command-Line Switch:	\fB-printregion\fR
.fi
.IP
A list of four coordinates specifying which part of the canvas to print.
An empty list means that the canvas' entire \fBscrollregion\fR should be
printed. Any change to this attribute will automatically update the "stamp".
Defaults to an empty list.
.LP
.nf
Name:	\fBstretch\fR
Class:	\fBStretch\fR
Command-Line Switch:	\fB-stretch\fR
.fi
.IP
Determines if the output should be stretched to fill the
page (as defined by the attribute pagesize) as large as
possible. The aspect-ratio of the output will be retained
and the output will never fall outside of the boundaries
of the page.
Defaults to 0 but will be changed automaticaly to the value
deemed appropiate for the current canvas. Setting this attribute
when the canvasprintbox is first constructed (instead of using the
"configure" method) will turn off the auto adjustment of this attribute.
.LP
.nf
Name:	\fBvPageCnt\fR
Class:	\fBPageCnt\fR
Command-Line Switch:	\fB-vpagecnt\fR
.fi
.IP
Is used in combination with "posterize" to determine over
how many pages the output should be distributed. This
attribute specifies how many pages should be used verticaly.
Any change to this attribute will automatically update the "stamp".
Defaults to 1.
.LP
.BE

.SH DESCRIPTION
.PP
Implements a print box for printing the contents of a canvas widget
to a printer or a file. It is possible to specify page orientation, the
number of pages to print the image on and if the output should be
stretched to fit the page. Options exist to control the appearance and
actions of the widget.

.SH "METHODS"
.PP
The \fBcanvasprintbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for canvasprintbox widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcanvasprintbox\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcanvasprintbox\fR
command.
.TP
\fIpathName\fR \fBgetoutput\fR
Returns the value of the \fBprintercmd\fR or \fBfilename\fR option
depending on the current setting of \fBoutput\fR.
.TP
\fIpathName\fR \fBprint\fR
Perfrom the actual printing of the canvas using the current settings of
all the attributes. Returns a boolean indicating wether the printing was
successful or not.
.TP
\fIpathName\fR \fBrefresh\fR
Retrieves the current value for all edit fields and updates
the stamp accordingly. Is useful for Apply-buttons.
.TP
\fIpathName\fR \fBsetcanvas\fR \fIcanvas\fR
This is used to set the \fIcanvas\fR that has to be printed.
A stamp-sized copy will automatically be drawn to show how the
output would look with the current settings.
.TP
\fIpathName \fBstop\fR
Stops the drawing of the "stamp". I'm currently unable to detect
when a Canvasprintbox gets destroyed or withdrawn. It's therefore
advised that you perform a stop before you do something like that.
.SH "COMPONENTS"
.LP
.nf
Name:	\fBprtflentry\fR
Class:	\fBEntry\fR
.fi
.IP
The prtflentry component is the entry field for user input of the
\fBfilename\fR or \fBprinter\fR command (depending on the value of
\fBoutput\fR).
.LP
.nf
Name:	\fBhpcnt\fR
Class:	\fBEntry\fR
.fi
.IP
The hpcnt component is the entry field for user input of the number of
pages to use horizontaly when \fBposterize\fR is turned on.
.fi
.nf
Name:	\fBvpcnt\fR
Class:	\fBEntry\fR
.fi
.IP
The vpcnt component is the entry field for user input of the number of
pages to use verticaly when \fBposterize\fR is turned on.
.fi

.SH EXAMPLE
.DS
option add *textBackground GhostWhite

canvasprintbox .fsb -orient landscape -stretch 1
pack .fsb -padx 10 -pady 10 -fill both -expand yes 
.DE
.SH AUTHOR
Tako Schotanus
.LP
Tako.Schotanus@bouw.tno.nl
.SH KEYWORDS
canvasprintbox, widget
