#ifndef OPT_INT_H
#define OPT_INT_H

/*
 * optInt.h - internal shared facilities of Tcl-Option
 *
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: optionInt.h,v 1.2 1996/05/04 21:00:44 aku Exp $
 */

#include "option.h"

#ifndef TRUE
#define TRUE  (1)
#define FALSE (0)
#endif

/*
 * Internal definition of an option table.
 */

typedef struct Opt_ITable
{
  Opt_Table     slave; /* link to slave table */
  Tcl_HashTable def;   /* table of option definitions
			* indexed by option-names. the associated value is a
			* reference to the handler procedure of the option.
			*/
} Opt_ITable;


/*
 * Remarks:
 *
 * This extension associates its own data structures with
 * any interpreter initializing it.  This is done via
 * 'Tcl_SetAssocData' and surrounding procedures.  The key
 * used here is "Option".
 */

#define ASSOC_KEY "Option"

#endif /* OPT_INT_H */
