
/*
 * md5tcl.c --
 *
 *	Implementation of interface to MD5 one-way hash function.
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: md5tcl.c,v 1.3 1996/01/14 16:22:59 aku Exp $
 */

#include <md5.h>
#include <blobXInt.h>


/*
 *------------------------------------------------------*
 *
 *	Md5Operator --
 *
 *	------------------------------------------------*
 *	Computes the 'md5'-hashfunction over (length,data)
 *	and stores the generated value in 'resBlob'.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		None.
 *
 *	Result:
 *		a standard TCL error code + see above.
 *
 *------------------------------------------------------*
 */

int
Md5Operator (interp, length, data, resBlob)
Tcl_Interp* interp;	/* interpreter we are working in */
int         length;	/* length of data to hash */
CONST char* data;	/* information to hash */
Blob        resBlob;    /* store computed hashvalue here */
{
  int     res;
  MD5_CTX hashContext;
  char    digest [16];

  /* calc hash value from input */

  MD5Init   (&hashContext);
  MD5Update (&hashContext, (char*) data, length);
  MD5Final  (digest, &hashContext);
  
  /* and store in result */

  res = Blob_SetData (resBlob, 16, digest);
  if (res != BLOB_OK)
    {
      Tcl_AppendResult (interp, "md5: ", Blob_LastError (resBlob), 0);
      return TCL_ERROR;
    }

  return TCL_OK;
}
