
/*
 * init.c --
 *
 *	Implementation of procedures initializing the extension.
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: init.c,v 1.7 1996/05/19 14:58:47 aku Exp $
 */

#include <assert.h>
#include <string.h>
#include <stdio.h>
#ifdef __STDC__
#include <stdlib.h>
#endif

#include <safer/safer.h>
#include "blobXInt.h"


/*
 *------------------------------------------------------*
 *
 *	Blobx_Init --
 *
 *	------------------------------------------------*
 *	creates all commands of the BLOB-X extension
 *	visible on TCL level.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		as of Tcl_CreateCommand
 *
 *	Result:
 *		a standard TCL error code.
 *
 *------------------------------------------------------*
 */

int
Blobx_Init (interp)
Tcl_Interp *interp;	/* interpreter to extend with
			 * blobX functionality */
{
  int   res;

  if (! Blob_IsInitialized (interp))
    {
      Blob_Init (interp);
    }

  if (! Opt_IsInitialized (interp))
    {
      Option_Init (interp);
    }

  Tcl_PkgRequire (interp, "Blob",   "1.1", 0);
  Tcl_PkgRequire (interp, "Option", "1.1", 0);

  res = BlobXRegisterIdea (interp);
  if (res != TCL_OK)
    return TCL_ERROR;

  res = BlobXRegisterSafer (interp);
  if (res != TCL_OK)
    return TCL_ERROR;

  res = BlobXRegisterDes (interp);
  if (res != TCL_OK)
    return TCL_ERROR;

  res = BlobXRegisterBlowfish (interp);
  if (res != TCL_OK)
    return TCL_ERROR;


  BlobX_RegisterUnaryOp (interp, "md5",   Md5Operator);
  BlobX_RegisterUnaryOp (interp, "haval", HavalOperator);
  BlobX_RegisterUnaryOp (interp, "crc",   PgpCrcOperator);

  Tcl_CreateCommand (interp, "crypt", BlobXCryptCmd, 0, 0);

  return Tcl_PkgProvide (interp, "BlobX", BLOBX_VERSION);;
}

/*
 *------------------------------------------------------*
 *
 *	Blobx_SafeInit --
 *
 *	------------------------------------------------*
 *	creates all commands of the BLOB-X extension
 *	visible on TCL level.
 *	VARIANT for safe interpreter
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		as of Tcl_CreateCommand
 *
 *	Result:
 *		a standard TCL error code.
 *
 *------------------------------------------------------*
 */

int
Blobx_SafeInit (interp)
Tcl_Interp *interp;	/* interpreter to extend with
			 * blob functionality */
{
  return Blobx_Init (interp);
}
