
/*
 * havaltcl.c --
 *
 *	Implementation of interface to HAVAL one-way hash function.
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: havaltcl.c,v 1.1 1996/02/11 00:03:14 aku Exp $
 */

#include <haval/haval.h>
#include <haval/havalapp.h>
#include <blobXInt.h>


/*
 *------------------------------------------------------*
 *
 *	HavalOperator --
 *
 *	------------------------------------------------*
 *	Computes the 'haval'-hashfunction over (length,data)
 *	and stores the generated value in 'resBlob'.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		None.
 *
 *	Result:
 *		a standard TCL error code + see above.
 *
 *------------------------------------------------------*
 */

int
HavalOperator (interp, length, data, resBlob)
Tcl_Interp* interp;	/* interpreter we are working in */
int         length;	/* length of data to hash */
CONST char* data;	/* information to hash */
Blob        resBlob;    /* store computed hashvalue here */
{
  haval_state hashContext;

  int     res;
  char    digest [FPTLEN >> 3];

  /* calc hash value from input */

  haval_start (&hashContext);
  haval_hash  (&hashContext, (char*) data, length);
  haval_end   (&hashContext, digest);
  
  /* and store in result */

  res = Blob_SetData (resBlob, FPTLEN >> 3, digest);
  if (res != BLOB_OK)
    {
      Tcl_AppendResult (interp, "haval: ", Blob_LastError (resBlob), 0);
      return TCL_ERROR;
    }

  return TCL_OK;
}
