
/*
 * destcl.c --
 *
 *	Implementation of interface to DES encryption algorithm.
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: destcl.c,v 1.2 1996/02/12 20:48:05 aku Exp $
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>

#include <libdes/des.h>
#undef ENCRYPT /* we define these ourselves */
#undef DECRYPT /* we define these ourselves */
#include <blobXInt.h>


/*
 * Declaration of internal procedures.
 */

#define DES_KEYSIZE    (8)  /* byte */
#define DES_BLOCKSIZE  (8)  /* byte */

static char*
des_schedule _ANSI_ARGS_ ((BlobX_BcOptInfo* optInfo, int* length));

static void
des_cipher _ANSI_ARGS_ ((VOID* keyschedule,
			 char* in,
			 char* out));

/*
 * Definition of keyschedule.
 */

typedef struct keyschedule {
  short            doEncryption; /* direction information */
  des_key_schedule desSchedule;  /* the real schedule of DES */
} keyschedule;


/*
 *------------------------------------------------------*
 *
 *	BlobXRegisterDes --
 *
 *	------------------------------------------------*
 *	Register interface to native DES implementation
 *	as block cipher.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		See above.
 *
 *	Result:
 *		a standard TCL error code
 *
 *------------------------------------------------------*
 */

int
BlobXRegisterDes (interp)
Tcl_Interp* interp;
{
  return BlobX_RegisterBC (interp,
			   "des",
			   DES_KEYSIZE,
			   DES_BLOCKSIZE,
			   des_schedule,
			   des_cipher,
			   0 /* no special cleanup, memset sufficient */,
			   0 /* no special context required */,
			   0 /* therefore no cleanup of context too */,
			   0 /* no additional options */,
			   0 /* therefore no additional option storage */,
			   0 /* no cleanup of additional option data */);
}

/*
 *------------------------------------------------------*
 *
 *	des_schedule --
 *
 *	------------------------------------------------*
 *	Interfaces native DES implementation with
 *	Tcl-BlobX according to block cipher interface.
 *
 *	This is the keyscheduler.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		Creates area containing internal key.
 *
 *	Result:
 *		Reference to allocated memory + length of that.
 *
 *------------------------------------------------------*
 */

static char*
des_schedule (optInfo, length)
BlobX_BcOptInfo* optInfo;
int* length;
{
  keyschedule* schedule;

  schedule = ckalloc (sizeof (keyschedule));
  assert (schedule);

  schedule->doEncryption = (optInfo->scs.direction == ENCRYPT);

  des_set_key ((des_cblock*) optInfo->scs.key.data,
	       schedule->desSchedule);

  *length = sizeof (keyschedule);
  return (char*) schedule;
}

/*
 *------------------------------------------------------*
 *
 *	des_cipher --
 *
 *	------------------------------------------------*
 *	Interfaces native DES implementation with
 *	Tcl-BlobX according to block cipher interface.
 *
 *	This is the encryption / decryption algorithm.
 *	------------------------------------------------*
 *
 *	Sideeffects:
 *		'out' is set up to be the encryption or
 *		decryption of 'in' (dependent on the
 *		arguments to the key scheduler (see above)).
 *
 *	Result:
 *		out.
 *
 *------------------------------------------------------*
 */

static void
des_cipher (schedule, in, out)
VOID* schedule;
char* in;
char* out;
{
  keyschedule* ks = (keyschedule*) schedule;

  des_ecb_encrypt ((des_cblock*) in,
		   (des_cblock*) out,
		   ks->desSchedule,
		   ks->doEncryption);
}

