/*
 * blowfish.c - implementation of the blockcipher Blowfish.
 *
 * This source is a modification of the original one made by Bruce Schneier.
 * The original files reside in the subdirectory 'blowfish'.
 *
 * CVS: $Id: blowfish.c,v 1.1 1996/05/19 14:58:46 aku Exp $
 */

/*********************blowfish.c*********************/

/* TODO: test with zero length key */
/* TODO: test with a through z as key and plain text */
/* TODO: make this byte order independent */

#include <stdio.h>		/* used for debugging */
#ifdef MACINTOSH
   #include <Types.h>		/* FIXME: do we need this? */
#endif

#include "blowfish.h"
#include "bf_tab.h"	/* P-box P-array, S-box  */

/* AKU / modified to use an explicit keyschedule pointer
 */
#if 0
#define S(x,i) (bf_S[i][x.w.byte##i])
#define bf_F(x) (((S(x,0) + S(x,1)) ^ S(x,2)) + S(x,3))
#define ROUND(a,b,n) (a.word ^= bf_F(b) ^ bf_P[n])
#else
#define S(x,i) (keyschedule->bf_S[i][x.w.byte##i])
#define bf_F(x) (((S(x,0) + S(x,1)) ^ S(x,2)) + S(x,3))
#define ROUND(a,b,n) (a.word ^= bf_F(b) ^ keyschedule->bf_P[n])
#endif

/*inline*/ void
Blowfish_encipher (Blowfish_keyschedule* keyschedule,
		   UWORD_32bits*         xl,
		   UWORD_32bits*         xr)
{
  union aword  Xl;
  union aword  Xr;

  Xl.word = *xl;
  Xr.word = *xr;

  Xl.word ^= keyschedule->bf_P [0];
  ROUND (Xr, Xl, 1);  ROUND (Xl, Xr, 2);
  ROUND (Xr, Xl, 3);  ROUND (Xl, Xr, 4);
  ROUND (Xr, Xl, 5);  ROUND (Xl, Xr, 6);
  ROUND (Xr, Xl, 7);  ROUND (Xl, Xr, 8);
  ROUND (Xr, Xl, 9);  ROUND (Xl, Xr, 10);
  ROUND (Xr, Xl, 11); ROUND (Xl, Xr, 12);
  ROUND (Xr, Xl, 13); ROUND (Xl, Xr, 14);
  ROUND (Xr, Xl, 15); ROUND (Xl, Xr, 16);
  Xr.word ^= keyschedule->bf_P [17];

  *xr = Xl.word;
  *xl = Xr.word;
}


void
Blowfish_decipher (Blowfish_keyschedule* keyschedule,
		   UWORD_32bits*         xl,
		   UWORD_32bits*         xr)
{
   union aword  Xl;
   union aword  Xr;

   Xl = *xl;
   Xr = *xr;

   Xl.word ^= keyschedule->bf_P [17];
   ROUND (Xr, Xl, 16);  ROUND (Xl, Xr, 15);
   ROUND (Xr, Xl, 14);  ROUND (Xl, Xr, 13);
   ROUND (Xr, Xl, 12);  ROUND (Xl, Xr, 11);
   ROUND (Xr, Xl, 10);  ROUND (Xl, Xr, 9);
   ROUND (Xr, Xl, 8);   ROUND (Xl, Xr, 7);
   ROUND (Xr, Xl, 6);   ROUND (Xl, Xr, 5);
   ROUND (Xr, Xl, 4);   ROUND (Xl, Xr, 3);
   ROUND (Xr, Xl, 2);   ROUND (Xl, Xr, 1);
   Xr.word ^= keyschedule->bf_P [0];

   *xl = Xr.word;
   *xr = Xl.word;
}


/* FIXME: Blowfish_Initialize() ??? */
short
InitializeBlowfish (UBYTE_08bits          key [],
		    short                 keybytes,
		    Blowfish_keyschedule* keyschedule)
{
  short          i;		/* FIXME: unsigned int, char? */
  short          j;		/* FIXME: unsigned int, char? */
  UWORD_32bits  data;
  UWORD_32bits  datal;
  UWORD_32bits  datar;
  union aword temp;

  /* AKU / 1) additional step: load keyschedule with initialization data.
   *     / 2) reference initializes keyschedule explicitly.
   */

  memcpy (keyschedule->bf_P, bf_P, (bf_N+2)*sizeof (UWORD_32bits));
  memcpy (keyschedule->bf_S, bf_S, 4*256   *sizeof (UWORD_32bits));

#ifdef DEBUG
  fprintf (stderr, "0x%x 0x%x ", bf_P [0], bf_P [1]); /* DEBUG */
  fprintf (stderr, "%d %d\n",    bf_P [0], bf_P [1]); /* DEBUG */
#endif

  j = 0;
  for (i = 0; i < (bf_N + 2); ++i)
    {
      temp.word    = 0;
      temp.w.byte0 = key [j];
      temp.w.byte1 = key [(j+1) % keybytes];
      temp.w.byte2 = key [(j+2) % keybytes];
      temp.w.byte3 = key [(j+3) % keybytes];
      data         = temp.word;

      keyschedule->bf_P [i] = keyschedule->bf_P [i] ^ data;
      j = (j + 4) % keybytes;
    }

  datal = 0x00000000;
  datar = 0x00000000;

  for (i = 0; i < (bf_N + 2); i += 2)
    {
      Blowfish_encipher(keyschedule, &datal, &datar);

      keyschedule->bf_P [i]   = datal;
      keyschedule->bf_P [i+1] = datar;
    }

  for (i = 0; i < 4; ++i)
    {
      for (j = 0; j < 256; j += 2)
	{
	  Blowfish_encipher(keyschedule, &datal, &datar);
   
	  keyschedule->bf_S [i][j]   = datal;
	  keyschedule->bf_S [i][j+1] = datar;
	}
    }

  return 0;
}
