#ifndef BLOB_X_INT_H
#define BLOB_X_INT_H

/*
 * blobXInt.h - internal shared facilities of Tcl-BLOB-X
 *
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: blobXInt.h,v 1.5 1996/05/19 14:58:44 aku Exp $
 */

#include <blobX.h>

#ifndef TRUE
#define TRUE  (1)
#define FALSE (0)
#endif

#ifndef Min
#define Min(a,b) ((a) < (b) ? (a) : (b))
#endif


EXTERN int
Md5Operator _ANSI_ARGS_ ((Tcl_Interp* interp,
			  int         length,
			  CONST char* data,
			  Blob        result));

EXTERN int
HavalOperator _ANSI_ARGS_ ((Tcl_Interp* interp,
			    int         length,
			    CONST char* data,
			    Blob        result));

EXTERN int
PgpCrcOperator _ANSI_ARGS_ ((Tcl_Interp* interp,
			     int         length,
			     CONST char* data,
			     Blob        result));

/*
 * Cryptosystems.
 */

/* IDEA.
 * block cipher created by Xuejia Lai and James L. Massey, of ETH Zurich.
 */

EXTERN int
BlobXRegisterIdea _ANSI_ARGS_ ((Tcl_Interp* interp));


/* SAFER.
 * block cipher created by James L. Massey, of ETH Zurich.
 */

EXTERN int
BlobXRegisterSafer _ANSI_ARGS_ ((Tcl_Interp* interp));


/* DES.
 * good old Data Encryption Standard.
 */

EXTERN int
BlobXRegisterDes _ANSI_ARGS_ ((Tcl_Interp* interp));


/* Blowfish.
 * Block cipher create by Bruce Schneier. In public domain.
 */

EXTERN int
BlobXRegisterBlowfish _ANSI_ARGS_ ((Tcl_Interp* interp));


/* Channel creation command.
 */

EXTERN int
BlobXCryptCmd _ANSI_ARGS_ ((ClientData  clientData,
			    Tcl_Interp* interp,
			    int         argc,
			    char**      argv));

#endif /* BLOB_X_INT_H */
