set rcsId {$Id: scwoop.tcl,v 1.2 1996/05/17 12:34:36 jfontain Exp $}



proc widget::widget {this path args} {
    set widget($this,path) $path
    # configure with constructor options
    eval widget::configure $this $args
}

proc widget::~widget {this} {
    destroy $widget($this,path)
}

virtual proc widget::configure {this args} {
    return [eval $widget($this,path) configure $args]
}

virtual proc widget::cget {this option} {
    return [$widget($this,path) cget $option]
}



# create a widget wrapper class for each native Tk widget

foreach class {button canvas entry frame label listbox menu menubutton message radiobutton scale scrollbar text toplevel} {
    # if parent is ., Tcl widget command automatically strips off extra dot, that is ..path becomes .path
    proc $class::$class {this tkParent args} widget "\[$class \$tkParent.\$this\] \$args" {}
    proc $class::~$class {this} {}
}



proc composite::composite {this base args} widget {$widget($base,path) $args} {
    # arguments are option/value pairs as are arguments to Tk widgets configure command

    set composite($this,base) $base
    set composite($this,children) {}

    # initialize option current values from derived class option descriptions default values
    foreach description [composite::options $this] {
        set composite($this,[lindex $description 0]) [lindex $description end]
    }
    # check validity of constructor options and override default options with constructor options so that components can be properly
    # configured when composite is complete
    foreach {option value} $args {
        if {![info exists composite($this,$option)]} {
            error "unknown option \"$option\""
        }
        set composite($this,$option) $value
    }
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
}

proc composite::~composite {this} {
    # delete child widgets in reverse order of creation just in case
    set length [llength $composite($this,children)]
    for {set index [expr $length-1]} {$index>=0} {incr index -1} {
        delete [lindex $composite($this,children) $index]
    }
}

# derived class implementation must return a list of {name dbname dbclass defaultValue} lists, as Tk widget configure options
# without current value, which the composite widget code manages separately
virtual proc composite::options {this}

proc composite::configure {this args} {
    if {![info exists composite($this,children)]} {
        # if invoked by widget base class constructor, do nothing as composite class part is not constructed yet
        return
    }
    if {[llength $args]==0} {
        return [composite::optionsDescription $this]
    }
    # check all options validity before doing anything else
    foreach {option value} $args {
        if {![info exists composite($this,$option)]} {
            error "unknown option \"$option\""
        }
    }
    if {[llength $args]==1} {
        return [composite::optionDescription $this [lindex $args 0]]
    }
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    composite::setOptions $this $args 0
}

proc composite::manage {this args} {
    # arguments are one or more child widgets (widget class is composite base class) associated with a name which can later be
    # used to retrieve the widget object and the widget path, at the composite level
    foreach {child name} $args {
        if {[string length $name]==0} {
            error "widget $child has no name"
        }
        if {[info exists composite($this,$name)]} {
            error "\"$name\" member name already exists in composite layer"
        }
        set composite($this,$name) $child
        set composite($this,$name,path) $widget($child,path)
        lappend composite($this,children) $child
    }
}

# must be invoked at the end of derived class constructor so that components are properly configured
proc composite::complete {this} {
    # force all options configuration as this is the first time composite widget components will be configured
    set pairs {}
    set prefixLength [string length $this,]
    foreach {index value} [array get composite $this,-*] {
        lappend pairs [string range $index $prefixLength end] $value
    }
    composite::setOptions $this $pairs 1
}

proc composite::cget {this option} {
    if {![info exists composite($this,$option)]} {
        error "unknown option \"$option\""
    }
    # return specified option current value
    return $composite($this,$option)
}

proc composite::setOptions {this options force} {
    foreach {option value} $options {
        if {$force||([string compare $composite($this,$option) $value]!=0)} {
            # derived (dynamic virtual) procedure must either accept the value or throw an error
            $composite($this,_derived)::set$option $this $value
            set composite($this,$option) $value
        }
    }
}

# may be used by derived class for options that it does not implement, but no error checking here, not optimal for debugging
proc composite::try {this option value} {
    catch {widget::configure $composite($this,base) $option $value}
    foreach child $composite($this,children) {
        catch {widget::configure $child $option $value}
    }
}

# build Tk widget like specified option description list
proc composite::optionDescription {this option} {
    foreach description [composite::options $this] {
        if {[string compare [lindex $description 0] $option]==0} {
            return [concat $description $composite($this,$option)]
        }
    }
}

# build Tk widget like option descriptions list for all supported options
proc composite::optionsDescription {this} {
    set descriptions {}
    foreach description [composite::options $this] {
        lappend descriptions [concat $description $composite($this,[lindex $description 0])]
    }
    return $descriptions
}
