set rcsId {$Id: scrolist.tcl,v 1.1 1996/05/17 23:35:02 jfontain Exp $}

proc scrollList::scrollList {this parentPath args} composite {
    [new button $parentPath -borderwidth 0 -state disabled -takefocus 0] $args
} {
    # use button as base so we can get the focus and highlight the surrounding border
    composite::manage $this [new listbox $widget($this,path) -width 0 -highlightthickness 0] listbox
    set listboxPath $composite($this,listbox,path)

    # when focus is set on base Tk widget, pass it on to listbox
    bind $widget($this,path) <FocusIn> "focus $listboxPath"
    # disable button 2 scrolling
    bind $listboxPath <Button2-Motion> break
    pack $listboxPath -side left -fill both -expand 1

    composite::manage $this\
        [new scrollbar $widget($this,path) -command "$listboxPath yview" -highlightthickness 0 -takefocus 0] scrollbar
    widget::configure $composite($this,listbox) -yscrollcommand "$composite($this,scrollbar,path) set"
    pack $composite($this,scrollbar,path) -fill y -expand 1

    composite::complete $this
}

proc scrollList::~scrollList {this} {}

proc scrollList::options {this} {
    return {\
        {-background background Background #d9d9d9} {-height height Height 10}\
        {-highlightthickness highlightThickness HighlightThickness 2} {-list list List {}} {-setgrid setGrid SetGrid 0}\
    }
}

proc scrollList::set-background {this value} {
    composite::try $this -background $value
}

proc scrollList::set-height {this value} {
    widget::configure $composite($this,listbox) -height $value
}

proc scrollList::set-list {this value} {
    set listboxPath $composite($this,listbox,path)
    $listboxPath delete 0 end
    eval $listboxPath insert 0 $value
    $listboxPath activate 0
}

proc scrollList::set-setgrid {this value} {
    widget::configure $composite($this,listbox) -setgrid $value
}

proc scrollList::set-highlightthickness {this value} {
    widget::configure $composite($this,base) -highlightthickness $value
}

# wrap all relevant listbox commands
foreach command {activate bbox curselection delete get index insert nearest scan see selection size} {
    proc scrollList::$command {this args} "eval \$composite(\$this,listbox,path) $command \$args"
}
