set rcsId {$Id: combolab.tcl,v 1.2 1996/05/19 18:29:58 jfontain Exp $}

source combobut.tcl

proc comboLabel::comboLabel {this parentPath args} composite {
    [new button $parentPath -state disabled -takefocus 0 -borderwidth 0] $args
} {
    # use button as base so we can get the focus
    composite::manage $this\
        [new label $widget($this,path) -relief sunken] label\
        [new comboButton $widget($this,path) -highlightthickness 0] button
    widget::configure $composite($this,button) -command "comboLabel::selected $this"
    pack $composite($this,label,path) -side left -fill x -expand 1
    pack $composite($this,button,path) -side right -anchor e
    composite::complete $this
}

proc comboLabel::~comboLabel {this} {}

proc comboLabel::options {this} {
    return {{-command command Command {}} {-list list List {}}}
}

# do nothing, command is stored at the composite level
proc comboLabel::set-command {this value} {}

proc comboLabel::set-list {this value} {
    widget::configure $composite($this,button) -list $value
}

proc comboLabel::selected {this entry} {
    widget::configure $composite($this,label) -text $entry
    if {[string length $composite($this,-command)]>0} {
        eval $composite($this,-command) \{$entry\}
    }
}
