set rcsId {$Id: combobut.tcl,v 1.2 1996/05/19 18:26:40 jfontain Exp $}

source arrowbut.tcl
source scrolist.tcl

proc comboButton::comboButton {this parentPath args} composite {[new arrowButton $parentPath] $args} {
    composite::manage $this [new toplevel $widget($this,path) -relief raised -borderwidth 1 -cursor right_ptr] shell
    set shellPath $composite($this,shell,path)
    bind $shellPath <Escape> "comboButton::unpopListBox $this"
    # allow any mouse click outside shell to unpop it
    bind $shellPath <Any-ButtonRelease> "comboButton::unpopListBox $this"
    # no window manager decorations
    wm overrideredirect $shellPath 1
    # list is invisible by default
    wm withdraw $shellPath

    composite::manage $this [new scrollList $shellPath -setgrid 1 -highlightthickness 0] scroll
    pack $composite($this,scroll,path)

    set listboxPath $composite($composite($this,scroll),listbox,path)
    # a button release or a space bar hit within the listbox means a selection
    bind $listboxPath <ButtonRelease-1> "comboButton::invokeCommand $this; comboButton::unpopListBox $this"
    bind $listboxPath <space> "comboButton::invokeCommand $this; comboButton::unpopListBox $this"
    bind $listboxPath <Return> "comboButton::invokeCommand $this; comboButton::unpopListBox $this"

    widget::configure $composite($this,base) -command "comboButton::popupListBox $this"

    composite::complete $this
}

proc comboButton::~comboButton {this} {}

proc comboButton::options {this} {
    return {{-command command Command {}} {-highlightthickness highlightThickness HighlightThickness 2} {-list list List {}}}
}

# do nothing, command is stored at the composite level
proc comboButton::set-command {this value} {}

proc comboButton::set-list {this value} {
    if {[llength $value]==0} {
        widget::configure $composite($this,base) -state disabled
    } else {
        widget::configure $composite($this,base) -state normal
    }
    widget::configure $composite($this,scroll) -list $value -height [llength $value]
}

proc comboButton::set-highlightthickness {this value} {
    widget::configure $composite($this,base) -highlightthickness $value
}

proc comboButton::popupListBox {this} {
    set arrowPath $widget($this,path)
    set shellPath $composite($this,shell,path)

    set x [expr [winfo rootx $arrowPath]+[winfo width $arrowPath]-[winfo reqwidth $shellPath]]
    set y [expr [winfo rooty $arrowPath]+[winfo height $arrowPath]]
    wm geometry $shellPath +$x+$y
    wm deiconify $shellPath
    raise $shellPath
    grab -global $shellPath
    focus $composite($this,scroll,path)
}

proc comboButton::unpopListBox {this} {
    wm withdraw $composite($this,shell,path)
    grab release $composite($this,shell,path)
}

proc comboButton::invokeCommand {this} {
    if {[string length $composite($this,-command)]>0} {
        eval $composite($this,-command)\
            \{[scrollList::get $composite($this,scroll) [scrollList::curselection $composite($this,scroll)]]\}
    }
}
