set rcsId {$Id: arrowbut.tcl,v 1.7 1996/05/19 22:17:34 jfontain Exp $}

proc arrowButton::arrowButton {this parentPath args} composite {
    [new button $parentPath -relief sunken -borderwidth 2 -state disabled -takefocus 0] $args
} {
    # use button as base so we can get the focus
    composite::manage $this [new frame $widget($this,path)] clipper
    composite::manage $this [new scrollbar\
        $composite($this,clipper,path) -repeatdelay 1000000 -borderwidth 0 -elementborderwidth 2 -highlightthickness 0\
    ] scrollbar

    # when focus is set by focus command, pass it on to scrollbar
    bind $widget($this,path) <FocusIn> "focus $composite($this,scrollbar,path)"

    place $composite($this,scrollbar,path) -relx 0.5 -rely 1 -anchor s
    pack $composite($this,clipper,path) -fill both -expand 1
    # always make scrollbar width match height so that only whole or part of bottom arrow shows
    bind $composite($this,clipper,path) <Configure> "$composite($this,scrollbar,path) configure -width %h"
    composite::complete $this
}

proc arrowButton::~arrowButton {this} {}

proc arrowButton::options {this} {
    return {\
        {-background background Background #d9d9d9} {-command command Command {}}\
        {-highlightbackground highlightBackground HighlightBackground #d9d9d9}\
        {-highlightcolor highlightColor HighlightColor Black} {-highlightthickness highlightThickness HighlightThickness 2}\
        {-state state State normal} {-troughcolor troughColor Background #c3c3c3} {-width width Width 15}\
    }
}

proc arrowButton::set-width {this value} {
    # arrow fits in a square only
    widget::configure $composite($this,clipper) -width $value -height $value
    # scrollbar is configured by binding
}

# do nothing, command will be stored at the composite level
proc arrowButton::set-command {this value} {}

foreach option {-background -highlightbackground -highlightcolor -troughcolor} {
    proc arrowButton::set$option {this value} "composite::try \$this $option \$value"
}

proc arrowButton::set-highlightthickness {this value} {
    widget::configure $composite($this,base) -highlightthickness $value
}

proc arrowButton::invokeCommand {this} {
    eval $composite($this,-command)
}

proc arrowButton::set-state {this value} {
    set scrollbar $composite($this,scrollbar)
    set path $composite($this,scrollbar,path)
    switch $value {
        disabled {
            widget::configure $scrollbar -takefocus 0
            bind $path <Any-Button> break
            bind $path <Enter> break
            bind $path <space> {}
            bind $path <Down> {}
            bind $path <ButtonRelease-1> break
            widget::configure $scrollbar -activebackground [widget::cget $scrollbar -background]
        }
        normal {
            widget::configure $composite($this,scrollbar) -takefocus 1
            bind $path <Any-Button> {}
            bind $path <Enter> {}
            bind $path <space> "arrowButton::invokeCommand $this"
            bind $path <Down> "arrowButton::invokeCommand $this"
            bind $path <ButtonRelease-1> "arrowButton::invokeCommand $this"
            # restore active background value to default
            widget::configure $scrollbar -activebackground [lindex [widget::configure $scrollbar -activebackground] 3]
        }
        default {
            error "bad state value \"$value\": must be normal or disabled"
        }
    }
}
