/*
 *	Utility command file for main C program
 *
 *  COPYRIGHT
 *	Michael K. Ganley
 *	mikegan@world.std.com
 *  31 August 1995
 *
 *
 */


#include <string.h>
#include <stdio.h>
#include <tcl.h>
#include <tk.h>	 
#include "inc_hdr.h"
#include "msg.h"
#include "hello.h"

extern int				Qid;


/*
*F+
******************************************************************************
*                     Standard C Language Function Header                    *
******************************************************************************
* Title:       Send to Q 
*
******************************************************************************
*F-
*/

int sendToQCmd( ClientData clientData, Tcl_Interp *interp,
	int argc, char **argv )
{
short		result;
GuiMessage	guimsg;
int			retcode;
int			var0;

/* fast parsing */

if( Tcl_GetInt( interp, argv[1], &var0) != TCL_OK )
	{
	return TCL_ERROR;
	}

guimsg.msg_type = MSG_TYPE1;
guimsg.core.msg1.var = var0;
guimsg.core.msg1.command = 0;

retcode = msgsnd( Qid, ( struct msgbuf *) &guimsg,
		sizeof( guimsg ) - sizeof( long ), 0 );


/* complete */

result = 1; /* fake it */

sprintf( interp->result, "%d", result );

return TCL_OK;

 
}




/*
*F+
******************************************************************************
*                     Standard C Language Function Header                    *
******************************************************************************
* Title:       Finally, a function that return the Date or Time formatted 
*
******************************************************************************
*F-
*/

int getDateTimeCmd( ClientData clientData, Tcl_Interp *interp,
	int argc, char **argv )
{
int				code;
int				fs1, fs2;
char			fdt[48];
time_t			lt;


/* fast parsing */

if( Tcl_GetInt( interp, argv[1], &code) != TCL_OK )
	{
	return TCL_ERROR;
	}

if( Tcl_GetInt( interp, argv[2], &fs1) != TCL_OK )
	{
	return TCL_ERROR;
	}

if( Tcl_GetInt( interp, argv[3], &fs2) != TCL_OK )
	{
	return TCL_ERROR;
	}

/* get time */
lt = time( NULL );


switch( code )
	{

	case 0:  /* date */

		switch( fs1 )
			{

			case 0:  /* format 0 */

				strftime( fdt, 47, "%a %b %d %Y", localtime(&lt) );

				break;

			case 1:  /* format 1 */

				strftime( fdt, 47, "%a %d %B %Y", localtime(&lt) );

				break;


			case 2:	 /* format 2 */

				strftime( fdt, 47, "%a %B %d, %Y", localtime(&lt) );	
				
				break;

			}


		break;


	case 1:  /* time */

		switch( fs2 )
			{

			case 0:  /* format 0 */

				strftime( fdt, 47, "%H:%M:%S", localtime(&lt) );

				break;

			case 1:	 /* format 1 */

				strftime( fdt, 47, "%H:%M:%S %Z", localtime(&lt) );
				
				break;

			case 3:	 /* format 2 */

				strftime( fdt, 47, "%I:%M %p %Z", localtime(&lt) );	
				
				break;


			}


		break;

	}


sprintf( interp->result, "%s", fdt );

return TCL_OK;

}


/* EOF */
