
/*
 * Adonis Tool Project :
 *  Modal Optimization Package
 *  written by E. Gendron & L. Demailly
 *
 * $Id: noise.c,v 1.3 1993/12/08 21:34:52 egendron Exp $ 
 *
 * Description : Computes the noise on a temporal data set. The noise is
 *               supposed to be white (= uncorrelated between two samples.)
 *
 * $Log: noise.c,v $
 * Revision 1.3  1993/12/08  21:34:52  egendron
 * OPT_corr
 *
 * Revision 1.2  1993/12/07  16:08:16  egendron
 * ajout rcsid
 *
 * Revision 1.1  1993/12/07  16:03:13  egendron
 * Initial revision
 *
 *
 */

static char *rcsid="$Id: noise.c,v 1.3 1993/12/08 21:34:52 egendron Exp $";

#include "appli.h"




/*
 * Computes the intercorrelation between two sets of data.
 * The result is divided by the number of elements or the array
 *
 */
static double intercorr( set1, set2, n )
     double	*set1,*set2;
     int	n;
{
int	i;
double	result;

if( n<1 ) return(0.00);
i=n;
result = 0.;
for(; i--;) {
  result += (*set1++) * (*set2++);
}
return( result/(double)n );
}




/*
 * Corr : do inter correlations
 *
 * usage : math_corr arr1 arr2 off1 off2 [nbr]
 *
 */

int
Math_CorrCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Client Data (unused) */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  int off1, off2;
  int nbr, tmp;
  Bin_Object *pa1,*pa2;
  double res;
  
  if (argc < 5 || argc > 6) 
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " array1 array2 offset1 offset2 ?dim?\"", (char *) NULL);
      return TCL_ERROR;
    }
  
  if (!(pa1=Bin_GetObjectAndCheck(interp,argv[1],"double*"))) return TCL_ERROR;
  if (!(pa2=Bin_GetObjectAndCheck(interp,argv[2],"double*"))) return TCL_ERROR;

  if ( Tcl_GetInt(interp,argv[3],&off1)==TCL_ERROR ) 
    return TCL_ERROR;
  if ( Tcl_GetInt(interp,argv[4],&off2)==TCL_ERROR ) 
    return TCL_ERROR;
  nbr = MIN(pa1->size/sizeof(double)-off1, pa2->size/sizeof(double)-off2);
  if ( nbr<1 )
    {
      Tcl_AppendResult(interp,"Min(a1.dim-off1,a2.dim-off2) < 1",NULL);
      return TCL_ERROR;
    }
  if( argc==6 ) 
    {
      if ( Tcl_GetInt(interp,argv[5],&tmp)==TCL_ERROR ) 
	return TCL_ERROR;
      if (tmp > nbr )
	{
	  Tcl_AppendResult(interp,"dim > Min(a1.dim-off1,a2.dim-off2)",NULL);
	  return TCL_ERROR;
	}
      nbr = tmp;
    }

  res=intercorr(((double *)pa1->data)+off1, ((double *)pa2->data)+off2, nbr);
  Tcl_PrintDouble(interp, res, interp->result );
  return TCL_OK;
}








/*
 * Computes the average value of a set of data.
 *
 */
double math_moy( set, n )
     double	*set;
     int	n;
{
int	i;
double	result;

if( n<1 ) return(0.00);
i=n;
result = 0.;
for(; i--;) {
  result += (*set++);
}
return( result/(double)n );
}




/*
 * Corr : compute average value of a data set
 *
 * usage : math_moy arr [offset] [nbr]
 *
 */

int
Math_MoyCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Client Data (unused) */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings.    */
{
  int offset;
  int nbr;
  Bin_Object *object;
  double res;
  
  if (argc < 2 || argc > 4) 
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " array ?offset? ?dim?\"", (char *) NULL);
      return TCL_ERROR;
    }
  
  if (!(object=Bin_GetObjectAndCheck(interp,argv[1],"double*"))) return TCL_ERROR;

  if (argc>2) {
    if ( Tcl_GetInt(interp,argv[2],&offset)==TCL_ERROR ) 
      return TCL_ERROR;
    if( offset > object->size / sizeof(double) ) {
      Tcl_AppendResult(interp,"offset too large for array.",NULL);
      return TCL_ERROR;
    }
  }
  else
    offset=0;

  if (argc>3) {
    if ( Tcl_GetInt(interp,argv[3],&nbr)==TCL_ERROR ) 
      return TCL_ERROR;
    if ( offset+nbr > object->size/sizeof(double)) {
      Tcl_AppendResult(interp,"size larger than objects size - offsets",NULL);
      return TCL_ERROR;
    }
  }
  else
    nbr = object->size / sizeof(double) - offset;

  res = math_moy( ((double *)object->data)+offset, nbr);
  Tcl_PrintDouble(interp, res, interp->result );
  return TCL_OK;
}

