/*
 *  MD5 interface to tcl
 *  written by L. Demailly - dl@hplyot.obspm.fr
 *  need tclbin package.
 *
 * $Id: md5tcl.c,v 1.3 1996/05/09 13:12:39 dl Exp $
 *
 * Description : call md5 functions
 *               
 * $Log: md5tcl.c,v $
 * Revision 1.3  1996/05/09  13:12:39  dl
 * prefixed MD5 functions by Bin_ to avoid clash with system defined ones
 * in dynamic loading (Solaris, SunOs,...)
 *
 * Revision 1.2  1996/05/02  20:32:39  dl
 * new Mdfive_Init for tcl7.5 auto load easy support
 * registering as Mdfive package
 *
 * Revision 1.1  1995/10/19  16:18:09  dl
 * Initial revision
 *
 *
 */

static char *rcsid="$Id: md5tcl.c,v 1.3 1996/05/09 13:12:39 dl Exp $";

#include "bindata.h"
#include "md5.h"


/*
 * md5 digest object
 * 
 * digest a 16 bytes object, will get the md5 digest of object
 */
int
Bin_Md5Cmd(cdata, interp, argc, argv)
    ClientData cdata;                   /* Client Data */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
  Bin_Object  *object,*digest;
  struct Bin_MD5Context ctx;

  if ( argc  != 3 ) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " digest object\"",
		       (char *) NULL);
      return TCL_ERROR;
  }
  
  if (!(digest=Bin_GetObject(interp,argv[1]))) return TCL_ERROR;
  if (!(object=Bin_GetObject(interp,argv[2]))) return TCL_ERROR;

  if ( digest->size != 16 ) {
     Tcl_AppendResult(interp, "digest \"", argv[1],
		       "\" should be 16 bytes long",
		       (char *) NULL);
      return TCL_ERROR;
  }

  Bin_MD5Init(&ctx);
  Bin_MD5Update(&ctx,object->data,object->size);
  Bin_MD5Final(digest->data, &ctx);
   
  return TCL_OK;
}

/*
 * because of package / lib management, the init name 
 * (and maybe the package itself) must not contain a number !
 */
int
Mdfive_Init(interp)
     Tcl_Interp *interp; /* The current Tcl interpreter */
{
  Tcl_CreateCommand(interp,"md5",Bin_Md5Cmd,NULL,NULL);
#if ( (TCL_MAJOR_VERSION > 7) || ( (TCL_MAJOR_VERSION == 7) && (TCL_MINOR_VERSION >= 5) ) )

  /* Tell that we need TclBin */
  /* but in fact Bin *must* be loaded before trying to load md5,
   * because we need the C function Bin_GetObject
   */
  if (Tcl_PkgRequire(interp, "Bin", BIN_VERSION_STR, 0) == NULL ) {
    return TCL_ERROR;
  }
  
  /* Register as a package */
  if (Tcl_PkgProvide(interp, "Mdfive", BIN_VERSION_STR) != TCL_OK) {
    return TCL_ERROR;
  }

#endif
  return TCL_OK;
}
