/* Example of definition of a new object (from C) : Matrix */

typedef struct {
    int     i;
    int     j;
    int	    transpose;
    double   **tab;
    double   *data;
    tfunc_obj *DeleteProc; /* function to be called when deleting the object */
} Matrix;


/*
 * create a new object matrix: tcl command
 *
 * as this command will use Bin_Def and thus needs the Types Hash Table,
 * you store this value at creat time in cdata by calling:

  Tcl_CreateCommand(interp,"mat_new",Mat_NewMatrixCmd,Bin_GetTHT(interp),NULL);

 *
 */
int  Mat_NewMatrixCmd(cdata, interp, argc, argv)
    ClientData cdata;			/* Client Data (Types Hash Table) */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings.    */
{
  Bin_Object	*objptr;
  long i,j,k,total_size,pad;
  char *name;
  Tcl_HashTable	*ht=(Tcl_HashTable *)cdata;
  
  Matrix	*mat;

  pad=sizeof(Matrix)%sizeof(double);
  if (pad) pad=sizeof(double)-pad;

  if ( argc!=4 ) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " name|#auto dimI dimJ\"", (char *)NULL);
      return TCL_ERROR;
  }
  
  if (!strcmp(argv[1],"#auto")) {name=Bin_GenerateName("Matrix");}
  else name=argv[1];

  if (Tcl_ExprLong(interp,argv[2],&i)==TCL_ERROR) {return TCL_ERROR;}
  if (Tcl_ExprLong(interp,argv[3],&j)==TCL_ERROR) {return TCL_ERROR;}

  if (_BIN_GETOBJECT(interp,name)) {
    Tcl_AppendResult(interp,"\"",name,"\" is already an object",NULL);
    return TCL_ERROR;
  }
  
  total_size= sizeof(Matrix)+ pad + sizeof(double)*i*j + sizeof(double *)*i ;
  objptr=Bin_NewObject(NULL,total_size,(Bin_Object *)NULL,"Matrix",Bin_TraceObject);
  
  
  if (objptr==NULL) {
      Tcl_SetResult(interp,"Can't allocate matrix!",TCL_STATIC);
      return TCL_ERROR;
  }
  mat=objptr->data;

  mat->data = (double*) ( (char*)mat+pad+sizeof(Matrix) );
  mat->tab  = (double**)( (char*)mat->data+sizeof(double)*i*j );

  for(k=0; k<i; k++)
      mat->tab[k] = mat->data+k*j;

  mat->i = i;
  mat->j = j;
  mat->transpose=0;

  if (Bin_TclAttach(interp,objptr,name,NULL,0)!=TCL_OK) return TCL_ERROR;
  
  if (Bin_Def(ht,interp,name,"dimI","int",0,1)==TCL_ERROR) return TCL_ERROR;
  if (Bin_Def(ht,interp,name,"dimJ","int",4,1)==TCL_ERROR) return TCL_ERROR;
  if (Bin_Def(ht,interp,name,"transpose","int",8,1)==TCL_ERROR) 
    return TCL_ERROR; 
  if (Bin_Def(ht,interp,name,"data","double",
	      sizeof(Matrix)+pad,
	      i*j)==TCL_ERROR) return TCL_ERROR;
  Tcl_SetVar2(interp,name,"offset",ltoa(sizeof(Matrix)+pad),0);

  return TCL_OK;
}

